/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.config.JsonMapper;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.service.handler.Oauth2ServiceServiceIdGetHandler;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServiceServiceIdDeleteHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    static final String SERVICE_NOT_FOUND = "ERR12015";
    static Logger logger = LoggerFactory.getLogger(Oauth2ServiceServiceIdGetHandler.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String serviceId = exchange.getQueryParameters().get("serviceId").getFirst();
        IMap serviceEndpoints = CacheStartupHookProvider.hz.getMap("serviceEndpoints");
        IMap services = CacheStartupHookProvider.hz.getMap("services");
        if (services.get(serviceId) == null) {
            this.setExchangeStatus(exchange, SERVICE_NOT_FOUND, serviceId);
        } else {
            serviceEndpoints.delete(serviceId);
            services.delete(serviceId);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("serviceId", serviceId);
            exchange.getResponseSender().send(JsonMapper.toJson(result));
        }
        this.processAudit(exchange);
    }
}

