/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Service;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServicePutHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    static Logger logger;
    private static final String SERVICE_NOT_FOUND = "ERR12015";
    private static final String INCORRECT_TOKEN_TYPE = "ERR11601";
    private static final String PERMISSION_DENIED = "ERR11620";
    private static final String OPENAPI_SECURITY_CONFIG = "openapi-security";
    private static final String ENABLE_VERIFY_JWT = "enableVerifyJwt";
    private static boolean enableSecurity;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        IMap<String, Service> services;
        Map body = (Map)exchange.getAttachment(BodyHandler.REQUEST_BODY);
        Service service = Config.getInstance().getMapper().convertValue((Object)body, Service.class);
        String serviceId = service.getServiceId();
        if (enableSecurity) {
            String ownerId = service.getOwnerId();
            Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
            String userId = (String)auditInfo.get("user_id");
            String roles = (String)auditInfo.get("roles");
            if (userId == null) {
                this.setExchangeStatus(exchange, INCORRECT_TOKEN_TYPE, "Authorization Code Token");
                return;
            }
            if (!(userId.equals(ownerId) || roles != null && roles.contains("admin"))) {
                this.setExchangeStatus(exchange, PERMISSION_DENIED, roles);
                return;
            }
        }
        if ((services = CacheStartupHookProvider.hz.getMap("services")).get(serviceId) == null) {
            this.setExchangeStatus(exchange, SERVICE_NOT_FOUND, serviceId);
        } else {
            services.set(serviceId, service);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(service));
        }
        this.processAudit(exchange);
    }

    static {
        Object object;
        logger = LoggerFactory.getLogger(Oauth2ServicePutHandler.class);
        enableSecurity = false;
        Map<String, Object> config = Config.getInstance().getJsonMapConfig(OPENAPI_SECURITY_CONFIG);
        if (config == null) {
            config = Config.getInstance().getJsonMapConfig("security");
        }
        enableSecurity = (object = config.get(ENABLE_VERIFY_JWT)) != null && Boolean.valueOf(object.toString()) != false;
    }
}

