/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Service;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServicePostHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    static Logger logger;
    static final String SERVICE_ID_EXISTS = "ERR12018";
    private static final String INCORRECT_TOKEN_TYPE = "ERR11601";
    private static final String OPENAPI_SECURITY_CONFIG = "openapi-security";
    private static final String ENABLE_VERIFY_JWT = "enableVerifyJwt";
    private static boolean enableSecurity;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map body = (Map)exchange.getAttachment(BodyHandler.REQUEST_BODY);
        Service service = Config.getInstance().getMapper().convertValue((Object)body, Service.class);
        if (enableSecurity) {
            Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
            String userId = (String)auditInfo.get("user_id");
            if (userId == null) {
                this.setExchangeStatus(exchange, INCORRECT_TOKEN_TYPE, "Authorization Code Token");
                return;
            }
            service.setOwnerId(userId);
        }
        String serviceId = service.getServiceId();
        IMap<String, Service> services = CacheStartupHookProvider.hz.getMap("services");
        if (services.get(serviceId) == null) {
            services.set(serviceId, service);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(service));
        } else {
            this.setExchangeStatus(exchange, SERVICE_ID_EXISTS, serviceId);
        }
        this.processAudit(exchange);
    }

    static {
        Object object;
        logger = LoggerFactory.getLogger(Oauth2ServicePostHandler.class);
        enableSecurity = false;
        Map<String, Object> config = Config.getInstance().getJsonMapConfig(OPENAPI_SECURITY_CONFIG);
        if (config == null) {
            config = Config.getInstance().getJsonMapConfig("security");
        }
        enableSecurity = (object = config.get(ENABLE_VERIFY_JWT)) != null && Boolean.valueOf(object.toString()) != false;
    }
}

