/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.cache;

import com.hazelcast.map.MapStore;
import com.networknt.oauth.cache.model.User;
import com.networknt.service.SingletonServiceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapStore
implements MapStore<String, User> {
    static final Logger logger = LoggerFactory.getLogger(UserMapStore.class);
    static final DataSource ds = SingletonServiceFactory.getBean(DataSource.class);
    private static final String insert = "INSERT INTO user_profile (user_id, user_type, first_name, last_name, email, password, roles) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String delete = "DELETE FROM user_profile WHERE user_id = ?";
    private static final String select = "SELECT * FROM user_profile WHERE user_id = ?";
    private static final String update = "UPDATE user_profile SET user_type=?, first_name=?, last_name=?, email=?, password=?, roles=? WHERE user_id = ?";
    private static final String loadall = "SELECT user_id FROM user_profile";

    @Override
    public synchronized void delete(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete:" + key);
        }
        try (Connection connection = ds.getConnection();
             PreparedStatement stmt = connection.prepareStatement(delete);){
            stmt.setString(1, key);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error("Exception:", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void store(String key, User user) {
        block30: {
            if (logger.isDebugEnabled()) {
                logger.debug("Store:" + key);
            }
            if (this.load(key) == null) {
                try (Connection connection = ds.getConnection();
                     PreparedStatement stmt = connection.prepareStatement(insert);){
                    stmt.setString(1, user.getUserId());
                    stmt.setString(2, user.getUserType().toString());
                    stmt.setString(3, user.getFirstName());
                    stmt.setString(4, user.getLastName());
                    stmt.setString(5, user.getEmail());
                    stmt.setString(6, user.getPassword());
                    stmt.setString(7, user.getRoles());
                    stmt.executeUpdate();
                    break block30;
                }
                catch (SQLException e) {
                    logger.error("Exception:", e);
                    throw new RuntimeException(e);
                }
            }
            try (Connection connection = ds.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(update);){
                stmt.setString(1, user.getUserType().toString());
                stmt.setString(2, user.getFirstName());
                stmt.setString(3, user.getLastName());
                stmt.setString(4, user.getEmail());
                stmt.setString(5, user.getPassword());
                stmt.setString(6, user.getRoles());
                stmt.setString(7, user.getUserId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                logger.error("Exception:", e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void storeAll(Map<String, User> map) {
        for (Map.Entry<String, User> entry : map.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void deleteAll(Collection<String> keys2) {
        keys2.forEach(this::delete);
    }

    @Override
    public synchronized User load(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("Load:" + key);
        }
        User user = null;
        try (Connection connection = ds.getConnection();
             PreparedStatement stmt = connection.prepareStatement(select);){
            stmt.setString(1, key);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    user = new User();
                    user.setUserId(key);
                    user.setUserType(User.UserTypeEnum.fromValue(rs.getString("user_type")));
                    user.setFirstName(rs.getString("first_name"));
                    user.setLastName(rs.getString("last_name"));
                    user.setEmail(rs.getString("email"));
                    user.setPassword(rs.getString("password"));
                    user.setRoles(rs.getString("roles"));
                }
            }
        }
        catch (SQLException e) {
            logger.error("Exception:", e);
            throw new RuntimeException(e);
        }
        return user;
    }

    @Override
    public synchronized Map<String, User> loadAll(Collection<String> keys2) {
        HashMap<String, User> result = new HashMap<String, User>();
        for (String key : keys2) {
            result.put(key, this.load(key));
        }
        return result;
    }

    @Override
    public Iterable<String> loadAllKeys() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadAllKeys is called");
        }
        ArrayList<String> keys2 = new ArrayList<String>();
        try (Connection connection = ds.getConnection();
             PreparedStatement stmt = connection.prepareStatement(loadall);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                keys2.add(rs.getString("user_id"));
            }
        }
        catch (SQLException e) {
            logger.error("Exception:", e);
            throw new RuntimeException(e);
        }
        return keys2;
    }
}

