/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.msg;

import com.networknt.oas.validator.msg.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessagesHelper {
    private static final Pattern placeholderPattern = Pattern.compile("%(\\d+)|%\\{(\\d+)\\}");
    private static Map<Class<?>, Map<String, Properties>> localizationsByClass = new HashMap();

    public static String format(Locale locale, Messages message, Object ... args2) {
        String formatString = message.getFormatString(locale);
        Object[] sortArgs = MessagesHelper.sortArgs(formatString, args2);
        String printfString = Stream.of(formatString.split("%%")).map(part -> placeholderPattern.matcher((CharSequence)part).replaceAll("%s")).collect(Collectors.joining("%%"));
        return String.format(printfString, sortArgs);
    }

    private static Object[] sortArgs(String format, Object[] args2) {
        List<Integer> sites = MessagesHelper.findInterpolationSites(format);
        sites.stream().forEach(site -> {
            if (site < 1 || site > args2.length) {
                String msg = String.format("Interpolation position must be from 1 to %d: %%%d", args2.length, site);
                throw new IndexOutOfBoundsException(msg);
            }
        });
        return sites.stream().map(i -> args2[i - 1] != null ? args2[i - 1] : "").toArray();
    }

    private static List<Integer> findInterpolationSites(String format) {
        String[] parts;
        ArrayList<Integer> sites = new ArrayList<Integer>();
        for (String part : parts = format.split("%%")) {
            Matcher m4 = placeholderPattern.matcher(part);
            while (m4.find()) {
                boolean braces = m4.group(1) == null;
                String digits = m4.group(braces ? 2 : 1);
                int index = digits.isEmpty() ? 0 : Integer.valueOf(digits);
                sites.add(index);
            }
        }
        return sites;
    }

    public static Properties loadLocalizations(Class<? extends Messages> msgClass, Locale locale) {
        if (!localizationsByClass.containsKey(msgClass)) {
            localizationsByClass.put(msgClass, new HashMap());
        }
        Map<String, Properties> localizations = localizationsByClass.get(msgClass);
        for (String tag : Arrays.asList(locale.toLanguageTag(), locale.getLanguage())) {
            Properties result;
            if (!localizations.containsKey(tag)) {
                URL resource = msgClass.getResource(String.format("localizations/%s/messages.properties", tag));
                Properties props = null;
                if (resource != null) {
                    props = new Properties();
                    try (InputStream in = resource.openStream();){
                        props.load(in);
                    }
                    catch (IOException e) {
                        props = null;
                    }
                }
                localizations.put(tag, props);
            }
            if ((result = localizations.get(tag)) == null) continue;
            return result;
        }
        return null;
    }
}

