/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.info.ServerInfoConfig;
import com.networknt.security.IJwtVerifyHandler;
import com.networknt.server.ServerConfig;
import com.networknt.utility.FingerPrintUtil;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoGetHandler
implements LightHttpHandler {
    static final String STATUS_SERVER_INFO_DISABLED = "ERR10013";
    static final Logger logger = LoggerFactory.getLogger(ServerInfoGetHandler.class);
    static ServerInfoConfig config;

    public ServerInfoGetHandler() {
        if (logger.isDebugEnabled()) {
            logger.debug("ServerInfoGetHandler is constructed");
        }
        config = (ServerInfoConfig)Config.getInstance().getJsonObjectConfig("info", ServerInfoConfig.class);
        ModuleRegistry.registerModule("info", ServerInfoConfig.class.getName(), Config.getInstance().getJsonMapConfigNoCache("info"), null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (config.isEnableServerInfo()) {
            Map<String, Object> infoMap = ServerInfoGetHandler.getServerInfo(exchange);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(infoMap));
        } else {
            this.setExchangeStatus(exchange, STATUS_SERVER_INFO_DISABLED, new Object[0]);
        }
    }

    public static Map<String, Object> getServerInfo(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> infoMap = new LinkedHashMap<String, Object>();
        infoMap.put("deployment", ServerInfoGetHandler.getDeployment());
        infoMap.put("environment", ServerInfoGetHandler.getEnvironment(exchange));
        infoMap.put("security", ServerInfoGetHandler.getSecurity());
        infoMap.put("component", ServerInfoGetHandler.updateKey(ModuleRegistry.getRegistry()));
        return infoMap;
    }

    public static Map<String, Object> updateKey(Map<String, Object> moduleRegistry) {
        LinkedHashMap<String, Object> newModuleRegistry = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : moduleRegistry.entrySet()) {
            String key = entry.getKey();
            if (key.contains(":")) {
                key = key.substring(0, key.indexOf(":"));
            }
            newModuleRegistry.put(key, entry.getValue());
        }
        return newModuleRegistry;
    }

    public static Map<String, Object> getDeployment() {
        LinkedHashMap<String, Object> deploymentMap = new LinkedHashMap<String, Object>();
        deploymentMap.put("apiVersion", Util.getJarVersion());
        deploymentMap.put("frameworkVersion", ServerInfoGetHandler.getFrameworkVersion());
        return deploymentMap;
    }

    public static Map<String, Object> getEnvironment(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> envMap = new LinkedHashMap<String, Object>();
        envMap.put("host", ServerInfoGetHandler.getHost(exchange));
        envMap.put("runtime", ServerInfoGetHandler.getRuntime());
        envMap.put("system", ServerInfoGetHandler.getSystem());
        return envMap;
    }

    public static Map<String, Object> getSecurity() {
        LinkedHashMap<String, Object> secMap = new LinkedHashMap<String, Object>();
        Map<String, Object> moduleMap = ModuleRegistry.getRegistry();
        HashSet<String> fingerprints = new HashSet<String>();
        for (Map.Entry<String, Object> module : moduleMap.entrySet()) {
            if (!(module instanceof IJwtVerifyHandler)) continue;
            IJwtVerifyHandler handler = (IJwtVerifyHandler)((Object)module);
            fingerprints.addAll(handler.getJwtVerifier().getFingerPrints());
        }
        if (fingerprints.size() > 0) {
            secMap.put("oauth2FingerPrints", new ArrayList(fingerprints));
        }
        secMap.put("serverFingerPrint", ServerInfoGetHandler.getServerTlsFingerPrint());
        return secMap;
    }

    public static Map<String, Object> getHost(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> hostMap = new LinkedHashMap<String, Object>();
        String ip = "unknown";
        String hostname = "unknown";
        InetAddress inetAddress = Util.getInetAddress();
        ip = inetAddress.getHostAddress();
        hostname = inetAddress.getHostName();
        hostMap.put("ip", ip);
        hostMap.put("hostname", hostname);
        hostMap.put("dns", exchange.getSourceAddress().getHostName());
        return hostMap;
    }

    public static Map<String, Object> getRuntime() {
        LinkedHashMap<String, Object> runtimeMap = new LinkedHashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        runtimeMap.put("availableProcessors", runtime.availableProcessors());
        runtimeMap.put("freeMemory", runtime.freeMemory());
        runtimeMap.put("totalMemory", runtime.totalMemory());
        runtimeMap.put("maxMemory", runtime.maxMemory());
        return runtimeMap;
    }

    public static Map<String, Object> getSystem() {
        LinkedHashMap<String, Object> systemMap = new LinkedHashMap<String, Object>();
        Properties properties = System.getProperties();
        systemMap.put("javaVendor", properties.getProperty("java.vendor"));
        systemMap.put("javaVersion", properties.getProperty("java.version"));
        systemMap.put("osName", properties.getProperty("os.name"));
        systemMap.put("osVersion", properties.getProperty("os.version"));
        systemMap.put("userTimezone", properties.getProperty("user.timezone"));
        return systemMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFrameworkVersion() {
        String version = null;
        String path = "META-INF/maven/com.networknt/info/pom.properties";
        InputStream in = ClassLoader.getSystemResourceAsStream(path);
        try {
            Properties prop = new Properties();
            prop.load(in);
            version = prop.getProperty("version");
        }
        catch (Exception exception) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return version;
    }

    private static String getServerTlsFingerPrint() {
        String fingerPrint = null;
        ServerConfig serverConfig = ServerConfig.getInstance();
        String keystoreName = serverConfig.getKeystoreName();
        String keystorePass = serverConfig.getKeystorePass();
        if (keystoreName != null) {
            try (InputStream stream = Config.getInstance().getInputStreamFromFile(keystoreName);){
                KeyStore loadedKeystore = KeyStore.getInstance("JKS");
                loadedKeystore.load(stream, keystorePass.toCharArray());
                X509Certificate cert = (X509Certificate)loadedKeystore.getCertificate("server");
                if (cert != null) {
                    fingerPrint = FingerPrintUtil.getCertFingerPrint(cert);
                } else {
                    logger.error("Unable to find the certificate with alias name as server in the keystore");
                }
            }
            catch (Exception e) {
                logger.error("Unable to load server keystore ", e);
            }
        }
        return fingerPrint;
    }
}

