/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.conduit;

import com.networknt.handler.BuffersUtils;
import com.networknt.handler.ResponseInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.service.SingletonServiceFactory;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.ServerFixedLengthStreamSinkConduit;
import io.undertow.util.Headers;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;

public class ModifiableContentSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static int MAX_BUFFERS = 1024;
    static final Logger LOG = LoggerFactory.getLogger(ModifiableContentSinkConduit.class);
    private final HttpServerExchange exchange;
    private final ResponseInterceptor[] interceptors;
    private volatile boolean writingResponse = false;
    private final Object lock = new Object();

    public ModifiableContentSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this.exchange = exchange;
        this.interceptors = SingletonServiceFactory.getBeans(ResponseInterceptor.class);
        this.resetBufferPool(exchange);
    }

    private void resetBufferPool(HttpServerExchange exchange) {
        PooledByteBuffer[] oldBuffers = exchange.getAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY);
        if (oldBuffers != null) {
            for (PooledByteBuffer oldBuffer : oldBuffers) {
                if (oldBuffer == null) continue;
                oldBuffer.close();
            }
        }
        exchange.putAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY, new PooledByteBuffer[MAX_BUFFERS]);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return BuffersUtils.append(src, this.exchange.getAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY), this.exchange);
    }

    @Override
    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        for (int i = offs; i < len; ++i) {
            ByteBuffer srcBuffer = dsts[offs + i];
            if (!srcBuffer.hasRemaining()) continue;
            return this.write(srcBuffer);
        }
        return 0L;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source2, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void terminateWrites() throws IOException {
        if (this.interceptors == null || this.interceptors.length == 0) {
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        if (this.isWritingResponse()) return;
        ResponseInterceptor[] responseInterceptorArray = this.lock;
        synchronized (this.lock) {
            this.writingResponse = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (LOG.isTraceEnabled()) {
                LOG.trace("terminating writes with interceptors length = " + this.interceptors.length);
            }
            try {
                for (ResponseInterceptor interceptor : this.interceptors) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Executing interceptor " + interceptor.getClass());
                    }
                    interceptor.handleRequest(this.exchange);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) throw new RuntimeException(e);
                LOG.error("Error executing interceptors: " + e.getMessage(), e);
                throw new RuntimeException(e);
            }
            PooledByteBuffer[] dests = this.exchange.getAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Next conduit is: {}", (Object)((StreamSinkConduit)this.next).getClass().getName());
            }
            if (this.exchange.getResponseHeaders().get(Headers.CONTENT_LENGTH) != null) {
                this.updateContentLength(this.exchange, dests);
            }
            this.writeToNextConduit(dests);
            return;
        }
    }

    private void writeToNextConduit(PooledByteBuffer[] responseDataPooledBuffers) throws IOException {
        if (!(this.next instanceof StreamSinkChannelWrappingConduit)) {
            this.http1Write(responseDataPooledBuffers);
        } else {
            this.http2Write(responseDataPooledBuffers);
        }
    }

    private void http1Write(PooledByteBuffer[] buffers) throws IOException {
        for (PooledByteBuffer buffer : buffers) {
            if (buffer == null) break;
            if (LOG.isTraceEnabled()) {
                LOG.trace("buffer position {} and buffer limit {}", (Object)buffer.getBuffer().position(), (Object)buffer.getBuffer().limit());
            }
            while (buffer.getBuffer().position() < buffer.getBuffer().limit()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Before write buffer position: {}", (Object)buffer.getBuffer().position());
                }
                ((StreamSinkConduit)this.next).write(buffer.getBuffer());
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("After write buffer position: {}", (Object)buffer.getBuffer().position());
            }
        }
        ((StreamSinkConduit)this.next).terminateWrites();
    }

    private void http2Write(PooledByteBuffer[] buffers) {
        XnioIoThread ioThread = ((StreamSinkConduit)this.next).getWriteThread();
        XnioWorker workerThread = ((StreamSinkConduit)this.next).getWorker();
        if (ioThread != Thread.currentThread()) {
            throw new IllegalStateException("Conduit should not be called in a non IO-thread...");
        }
        this.executeHttp2WriteThread(workerThread, buffers);
    }

    private void executeHttp2WriteThread(XnioWorker workerThread, PooledByteBuffer[] buffers) {
        workerThread.execute(() -> {
            try {
                int index = 0;
                long totalWritten = 0L;
                for (PooledByteBuffer buffer : buffers) {
                    if (buffer == null || buffer.getBuffer() == null) break;
                    int written = 0;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("[{}] Before-Write: current pass: '{}' bytes, total: '{}' bytes, buffer size: '{}' bytes", index, written, totalWritten, buffer.getBuffer().limit());
                    }
                    boolean lastWrite = this.doWrite(buffers, buffer, written, index);
                    totalWritten += (long)written;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("[{}] After-Write: current pass: '{}' bytes, total: '{}' bytes, buffer size: '{}' bytes", index, written, totalWritten, buffer.getBuffer().limit());
                    }
                    buffer.close();
                    ++index;
                    if (lastWrite) break;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Terminating writes...");
                }
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute conduit writes on Worker Thread. " + e.getMessage(), e);
            }
        });
    }

    private boolean doWrite(PooledByteBuffer[] buffers, PooledByteBuffer buffer, int written, int index) throws IOException {
        boolean lastWrite = false;
        while (buffer.getBuffer().position() < buffer.getBuffer().limit()) {
            long res;
            if (this.isLastWrite(buffers, index)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Final write occurred...");
                }
                res = ((StreamSinkConduit)this.next).write(buffer.getBuffer());
                lastWrite = true;
            } else {
                res = ((StreamSinkConduit)this.next).write(buffer.getBuffer());
            }
            written = (int)((long)written + res);
            if (this.isBufferConsumed(buffer, res, index)) break;
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return lastWrite;
    }

    private boolean isBufferConsumed(PooledByteBuffer buffer, long res, int index) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] Checking if the buffer was fully consumed...", (Object)index);
        }
        return res != 0L && buffer.getBuffer().position() >= buffer.getBuffer().limit();
    }

    private boolean isLastWrite(PooledByteBuffer[] buffers, int index) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] Checking if this is the last write....", (Object)index);
        }
        return buffers[index + 1] == null || buffers[index + 1].getBuffer() == null;
    }

    private boolean isWritingResponse() {
        return this.writingResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateContentLength(HttpServerExchange exchange, PooledByteBuffer[] dests) {
        long length = 0L;
        for (PooledByteBuffer dest : dests) {
            if (dest == null) continue;
            length += (long)dest.getBuffer().limit();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("PooledByteBuffer array added up length = " + length);
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, length);
        if (this.next instanceof ServerFixedLengthStreamSinkConduit) {
            Method m4;
            if (LOG.isTraceEnabled()) {
                LOG.trace("The next conduit is ServerFixedLengthStreamSinkConduit and reset the length.");
            }
            try {
                m4 = ServerFixedLengthStreamSinkConduit.class.getDeclaredMethod("reset", Long.TYPE, HttpServerExchange.class);
                m4.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                if (!LOG.isErrorEnabled()) throw new RuntimeException("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
                LOG.error("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
                throw new RuntimeException("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
            }
            try {
                m4.invoke((Object)this.next, length, exchange);
                if (!LOG.isTraceEnabled()) return;
                LOG.trace("reset ServerFixedLengthStreamSinkConduit length = " + length);
                return;
            }
            catch (Throwable ex) {
                if (!LOG.isErrorEnabled()) throw new RuntimeException("could not access BUFFERED_REQUEST_DATA field", ex);
                LOG.error("could not access BUFFERED_REQUEST_DATA field", ex);
                throw new RuntimeException("could not access BUFFERED_REQUEST_DATA field", ex);
            }
        }
        if (!LOG.isWarnEnabled()) return;
        LOG.warn("updateContentLength() next is {}", (Object)((StreamSinkConduit)this.next).getClass().getSimpleName());
    }
}

