/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.BodyDumper;
import com.networknt.dump.CookiesDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.HeadersDumper;
import com.networknt.dump.IRequestDumpable;
import com.networknt.dump.IResponseDumpable;
import com.networknt.dump.QueryParametersDumper;
import com.networknt.dump.StatusCodeDumper;
import com.networknt.dump.UrlDumper;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DumperFactory {
    private Logger logger = LoggerFactory.getLogger(DumperFactory.class);
    private List<String> requestDumpers = Arrays.asList("body", "cookies", "headers", "queryParameters", "url");
    private List<String> responseDumpers = Arrays.asList("body", "cookies", "headers", "statusCode");

    DumperFactory() {
    }

    public List<IRequestDumpable> createRequestDumpers(DumpConfig config, HttpServerExchange exchange) {
        RequestDumperFactory factory2 = new RequestDumperFactory();
        ArrayList<IRequestDumpable> dumpers = new ArrayList<IRequestDumpable>();
        for (String dumperNames : this.requestDumpers) {
            IRequestDumpable dumper = factory2.create(dumperNames, config, exchange);
            if (dumper == null) continue;
            dumpers.add(dumper);
        }
        return dumpers;
    }

    public List<IResponseDumpable> createResponseDumpers(DumpConfig config, HttpServerExchange exchange) {
        ResponseDumperFactory factory2 = new ResponseDumperFactory();
        ArrayList<IResponseDumpable> dumpers = new ArrayList<IResponseDumpable>();
        for (String dumperNames : this.responseDumpers) {
            IResponseDumpable dumper = factory2.create(dumperNames, config, exchange);
            if (dumper == null) continue;
            dumpers.add(dumper);
        }
        return dumpers;
    }

    class ResponseDumperFactory {
        ResponseDumperFactory() {
        }

        IResponseDumpable create(String dumperName, DumpConfig config, HttpServerExchange exchange) {
            switch (dumperName) {
                case "body": {
                    return new BodyDumper(config, exchange);
                }
                case "cookies": {
                    return new CookiesDumper(config, exchange);
                }
                case "headers": {
                    return new HeadersDumper(config, exchange);
                }
                case "statusCode": {
                    return new StatusCodeDumper(config, exchange);
                }
            }
            DumperFactory.this.logger.error("unsupported dump type: {}", (Object)dumperName);
            return null;
        }
    }

    class RequestDumperFactory {
        RequestDumperFactory() {
        }

        IRequestDumpable create(String dumperName, DumpConfig config, HttpServerExchange exchange) {
            switch (dumperName) {
                case "body": {
                    return new BodyDumper(config, exchange);
                }
                case "cookies": {
                    return new CookiesDumper(config, exchange);
                }
                case "headers": {
                    return new HeadersDumper(config, exchange);
                }
                case "queryParameters": {
                    return new QueryParametersDumper(config, exchange);
                }
                case "url": {
                    return new UrlDumper(config, exchange);
                }
            }
            DumperFactory.this.logger.error("unsupported dump type: {}", (Object)dumperName);
            return null;
        }
    }
}

