/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.correlation;

import com.networknt.config.Config;
import com.networknt.correlation.CorrelationConfig;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CorrelationHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(CorrelationHandler.class);
    private static final String CID = "cId";
    public static CorrelationConfig config;
    private volatile HttpHandler next;

    public CorrelationHandler() {
        config = CorrelationConfig.load();
        if (logger.isInfoEnabled()) {
            logger.info("CorrelationHandler is loaded.");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String cId;
        if (logger.isDebugEnabled()) {
            logger.debug("CorrelationHandler.handleRequest starts.");
        }
        if ((cId = exchange.getRequestHeaders().getFirst(HttpStringConstants.CORRELATION_ID)) == null && config.isAutogenCorrelationID()) {
            cId = Util.getUUID();
            exchange.getRequestHeaders().put(HttpStringConstants.CORRELATION_ID, cId);
            String tId = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
            if (tId != null && logger.isInfoEnabled()) {
                logger.info("Associate traceability Id " + tId + " with correlation Id " + cId);
            }
        }
        MDC.put(CID, cId);
        if (cId != null) {
            this.addHandlerMDCContext(exchange, CID, cId);
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (HeaderValues header : exchange.getRequestHeaders()) {
                for (String value : header) {
                    sb.append(header.getHeaderName()).append("=").append(value).append("\n");
                }
            }
            logger.trace("Request Headers: " + sb);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CorrelationHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("correlation", CorrelationHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("correlation"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("correlation", CorrelationHandler.class.getName(), config.getMappedConfig(), null);
        if (logger.isInfoEnabled()) {
            logger.info("CorrelationHandler is enabled.");
        }
    }
}

