/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cluster;

import com.networknt.balance.LoadBalance;
import com.networknt.cluster.Cluster;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightCluster
implements Cluster {
    private static Logger logger = LoggerFactory.getLogger(LightCluster.class);
    private static Registry registry = SingletonServiceFactory.getBean(Registry.class);
    private static LoadBalance loadBalance = SingletonServiceFactory.getBean(LoadBalance.class);

    public LightCluster() {
        if (logger.isInfoEnabled()) {
            logger.info("A LightCluster instance is started");
        }
    }

    @Override
    public String serviceToUrl(String protocol, String serviceId, String tag, String requestKey) {
        if (StringUtils.isBlank(serviceId)) {
            logger.debug("The serviceId cannot be blank");
            return null;
        }
        URL url = loadBalance.select(this.discovery(protocol, serviceId, tag), serviceId, tag, requestKey);
        if (url != null) {
            logger.debug("Final url after load balance = {}.", (Object)url);
            return protocol + "://" + url.getHost() + ":" + url.getPort();
        }
        logger.debug("The service: {} cannot be found from service discovery.", (Object)serviceId);
        return null;
    }

    @Override
    public List<URI> services(String protocol, String serviceId, String tag) {
        if (StringUtils.isBlank(serviceId)) {
            logger.debug("The serviceId cannot be blank");
            return new ArrayList<URI>();
        }
        return this.discovery(protocol, serviceId, tag).stream().map(this::toUri).collect(Collectors.toList());
    }

    private List<URL> discovery(String protocol, String serviceId, String tag) {
        if (logger.isDebugEnabled()) {
            logger.debug("protocol = " + protocol + " serviceId = " + serviceId + " tag = " + tag);
        }
        URL subscribeUrl = URLImpl.valueOf(protocol + "://localhost/" + serviceId);
        if (tag != null) {
            subscribeUrl.addParameter("environment", tag);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("subscribeUrl = " + subscribeUrl);
        }
        registry.subscribe(subscribeUrl, null);
        List<URL> urls2 = registry.discover(subscribeUrl);
        if (logger.isDebugEnabled()) {
            logger.debug("discovered urls = " + urls2);
        }
        return urls2;
    }

    private URI toUri(URL url) {
        URI uri = null;
        try {
            uri = new URI(url.getProtocol(), null, url.getHost(), url.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            logger.error("URISyntaxExcpetion", e);
        }
        return uri;
    }
}

