/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.networknt.config.Config;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyConfig {
    private static final Logger logger = LoggerFactory.getLogger(BodyConfig.class);
    public static final String CONFIG_NAME = "body";
    private static final String ENABLED = "enabled";
    private static final String CACHE_REQUEST_BODY = "cacheRequestBody";
    private static final String CACHE_RESPONSE_BODY = "cacheResponseBody";
    private static final String LOG_FULL_REQUEST_BODY = "logFullRequestBody";
    private static final String LOG_FULL_RESPONSE_BODY = "logFullResponseBody";
    boolean enabled;
    boolean cacheRequestBody;
    boolean cacheResponseBody;
    boolean logFullRequestBody;
    boolean logFullResponseBody;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    public BodyConfig() {
        this(CONFIG_NAME);
    }

    private BodyConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static BodyConfig load() {
        return new BodyConfig();
    }

    public static BodyConfig load(String configName) {
        return new BodyConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCacheRequestBody() {
        return this.cacheRequestBody;
    }

    public boolean isCacheResponseBody() {
        return this.cacheResponseBody;
    }

    public boolean isLogFullRequestBody() {
        return this.logFullRequestBody;
    }

    public boolean isLogFullResponseBody() {
        return this.logFullResponseBody;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.mappedConfig.get(CACHE_REQUEST_BODY)) != null) {
            this.cacheRequestBody = Config.loadBooleanValue(CACHE_REQUEST_BODY, object);
        }
        if ((object = this.mappedConfig.get(CACHE_RESPONSE_BODY)) != null) {
            this.cacheResponseBody = Config.loadBooleanValue(CACHE_RESPONSE_BODY, object);
        }
        if ((object = this.mappedConfig.get(LOG_FULL_REQUEST_BODY)) != null) {
            this.logFullRequestBody = Config.loadBooleanValue(LOG_FULL_REQUEST_BODY, object);
        }
        if ((object = this.mappedConfig.get(LOG_FULL_RESPONSE_BODY)) != null) {
            this.logFullResponseBody = Config.loadBooleanValue(LOG_FULL_RESPONSE_BODY, object);
        }
    }
}

