/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuditConfig.class);
    public static final String REQUEST_BODY = "requestBody";
    public static final String RESPONSE_BODY = "responseBody";
    private static final String HEADERS = "headers";
    private static final String AUDIT = "audit";
    private static final String STATUS_CODE = "statusCode";
    private static final String RESPONSE_TIME = "responseTime";
    private static final String AUDIT_ON_ERROR = "auditOnError";
    private static final String LOG_LEVEL_IS_ERROR = "logLevelIsError";
    private static final String MASK = "mask";
    private static final String TIMESTAMP_FORMAT = "timestampFormat";
    private static final String ENABLED = "enabled";
    private static final String REQUEST_BODY_MAX_SIZE = "requestBodyMaxSize";
    private static final String RESPONSE_BODY_MAX_SIZE = "responseBodyMaxSize";
    private Map<String, Object> mappedConfig;
    public static final String CONFIG_NAME = "audit";
    private List<String> headerList;
    private List<String> auditList;
    private Config config = Config.getInstance();
    private Consumer<String> auditFunc;
    private boolean statusCode;
    private boolean responseTime;
    private boolean auditOnError;
    private boolean mask;
    private String timestampFormat;
    private int requestBodyMaxSize;
    private int responseBodyMaxSize;
    private boolean enabled;

    private AuditConfig() {
        this("audit");
    }

    private AuditConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setLists();
        this.setLogLevel();
        this.setConfigData();
    }

    public static AuditConfig load() {
        return new AuditConfig();
    }

    public static AuditConfig load(String configName) {
        return new AuditConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache("audit");
        this.setLists();
        this.setLogLevel();
        this.setConfigData();
    }

    public List<String> getHeaderList() {
        return this.headerList;
    }

    public List<String> getAuditList() {
        return this.auditList;
    }

    public Consumer<String> getAuditFunc() {
        return this.auditFunc;
    }

    public boolean isAuditOnError() {
        return this.auditOnError;
    }

    public boolean isMask() {
        return this.mask;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isResponseTime() {
        return this.responseTime;
    }

    public boolean isStatusCode() {
        return this.statusCode;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean hasHeaderList() {
        return this.getHeaderList() != null && this.getHeaderList().size() > 0;
    }

    public boolean hasAuditList() {
        return this.getAuditList() != null && this.getAuditList().size() > 0;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public int getRequestBodyMaxSize() {
        return this.requestBodyMaxSize;
    }

    public int getResponseBodyMaxSize() {
        return this.responseBodyMaxSize;
    }

    Config getConfig() {
        return this.config;
    }

    private void setLogLevel() {
        Object object = this.getMappedConfig().get(LOG_LEVEL_IS_ERROR);
        this.auditFunc = object != null && ((Boolean)object).booleanValue() ? LoggerFactory.getLogger("Audit")::error : LoggerFactory.getLogger("Audit")::info;
    }

    private void setLists() {
        String s2;
        if (this.getMappedConfig().get(HEADERS) instanceof String) {
            s2 = (String)this.getMappedConfig().get(HEADERS);
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s2);
            }
            if (s2.startsWith("[")) {
                try {
                    this.headerList = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                }
                catch (Exception e) {
                    throw new ConfigException("could not parse the headers json with a list of strings.");
                }
            } else {
                this.headerList = Arrays.asList(s2.split("\\s*,\\s*"));
            }
        } else if (this.getMappedConfig().get(HEADERS) instanceof List) {
            this.headerList = (List)this.getMappedConfig().get(HEADERS);
        } else {
            throw new ConfigException("headers list is missing or wrong type.");
        }
        if (this.getMappedConfig().get("audit") instanceof String) {
            s2 = (String)this.getMappedConfig().get("audit");
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s2);
            }
            if (s2.startsWith("[")) {
                try {
                    this.auditList = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                }
                catch (Exception e) {
                    throw new ConfigException("could not parse the audit json with a list of strings.");
                }
            } else {
                this.auditList = Arrays.asList(s2.split("\\s*,\\s*"));
            }
        } else if (this.getMappedConfig().get("audit") instanceof List) {
            this.auditList = (List)this.getMappedConfig().get("audit");
        } else {
            throw new ConfigException("audit list is missing or wrong type.");
        }
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(STATUS_CODE);
        if (object != null) {
            this.statusCode = Config.loadBooleanValue(STATUS_CODE, object);
        }
        if ((object = this.getMappedConfig().get(RESPONSE_TIME)) != null) {
            this.responseTime = Config.loadBooleanValue(RESPONSE_TIME, object);
        }
        if ((object = this.getMappedConfig().get(AUDIT_ON_ERROR)) != null) {
            this.auditOnError = Config.loadBooleanValue(AUDIT_ON_ERROR, object);
        }
        if ((object = this.getMappedConfig().get(MASK)) != null) {
            this.mask = Config.loadBooleanValue(MASK, object);
        }
        if ((object = this.mappedConfig.get(REQUEST_BODY_MAX_SIZE)) != null) {
            this.requestBodyMaxSize = Config.loadIntegerValue(REQUEST_BODY_MAX_SIZE, object);
        }
        if ((object = this.mappedConfig.get(RESPONSE_BODY_MAX_SIZE)) != null) {
            this.responseBodyMaxSize = Config.loadIntegerValue(RESPONSE_BODY_MAX_SIZE, object);
        }
        if ((object = this.getMappedConfig().get(ENABLED)) != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        this.timestampFormat = (String)this.getMappedConfig().get(TIMESTAMP_FORMAT);
    }
}

