/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.ExecutorStats;

public class StatsAwareRunnable
implements Runnable {
    private final long creationTime = Clock.currentTimeMillis();
    private final Runnable runnable;
    private final String executorName;
    private final ExecutorStats offloadedExecutorStats;

    public StatsAwareRunnable(Runnable runnable2, String executorName, ExecutorStats offloadedExecutorStats) {
        this.runnable = runnable2;
        this.executorName = executorName;
        this.offloadedExecutorStats = offloadedExecutorStats;
        offloadedExecutorStats.startPending(executorName);
    }

    @Override
    public void run() {
        long start = Clock.currentTimeMillis();
        this.offloadedExecutorStats.startExecution(this.executorName, start - this.creationTime);
        try {
            this.runnable.run();
        }
        finally {
            this.offloadedExecutorStats.finishExecution(this.executorName, Clock.currentTimeMillis() - start);
        }
    }
}

