/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.scheduledexecutor.impl.AbstractTaskDecorator;
import java.io.IOException;
import java.util.concurrent.Callable;

public class NamedTaskDecorator<V>
extends AbstractTaskDecorator<V>
implements NamedTask,
Versioned {
    private String name;

    NamedTaskDecorator() {
    }

    private NamedTaskDecorator(String name, Runnable runnable2) {
        super(runnable2);
        this.name = name;
    }

    private NamedTaskDecorator(String name, Callable<V> callable) {
        super(callable);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (out.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            super.writeData(out);
            out.writeString(this.name);
        } else {
            out.writeString(this.name);
            out.writeObject(this.delegate);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        if (in.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            super.readData(in);
            this.name = in.readString();
        } else {
            this.name = in.readString();
            this.delegate = in.readObject();
        }
    }

    public static Runnable named(String name, Runnable runnable2) {
        return new NamedTaskDecorator(name, runnable2);
    }

    public static <V> Callable<V> named(String name, Callable<V> callable) {
        return new NamedTaskDecorator<V>(name, callable);
    }
}

