/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.map.MapLoader;
import java.util.Collection;
import java.util.Map;

public class LatencyTrackingMapLoader<K, V>
implements MapLoader<K, V> {
    static final String KEY = "MapStoreLatency";
    private final StoreLatencyPlugin.LatencyProbe loadProbe;
    private final StoreLatencyPlugin.LatencyProbe loadAllKeysProbe;
    private final StoreLatencyPlugin.LatencyProbe loadAllProbe;
    private final MapLoader<K, V> delegate;

    public LatencyTrackingMapLoader(MapLoader<K, V> delegate, StoreLatencyPlugin plugin, String mapName) {
        this.delegate = delegate;
        this.loadProbe = plugin.newProbe(KEY, mapName, "load");
        this.loadAllProbe = plugin.newProbe(KEY, mapName, "loadAll");
        this.loadAllKeysProbe = plugin.newProbe(KEY, mapName, "loadAllKeys");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V load(K key) {
        long startNanos = Timer.nanos();
        try {
            V v = this.delegate.load(key);
            return v;
        }
        finally {
            this.loadProbe.recordValue(Timer.nanosElapsed(startNanos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> loadAll(Collection<K> keys2) {
        long startNanos = Timer.nanos();
        try {
            Map<K, V> map = this.delegate.loadAll(keys2);
            return map;
        }
        finally {
            this.loadAllProbe.recordValue(Timer.nanosElapsed(startNanos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<K> loadAllKeys() {
        long startNanos = Timer.nanos();
        try {
            Iterable<K> iterable = this.delegate.loadAllKeys();
            return iterable;
        }
        finally {
            this.loadAllKeysProbe.recordValue(Timer.nanosElapsed(startNanos));
        }
    }
}

