/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.NopScheduler;
import com.hazelcast.internal.tpcengine.Reactor;
import com.hazelcast.internal.tpcengine.ReactorType;
import com.hazelcast.internal.tpcengine.Scheduler;
import com.hazelcast.internal.tpcengine.TpcEngine;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import com.hazelcast.internal.util.ThreadAffinity;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public abstract class ReactorBuilder {
    public static final String NAME_LOCAL_TASK_QUEUE_CAPACITY = "hazelcast.tpc.localTaskQueue.capacity";
    public static final String NAME_EXTERNAL_TASK_QUEUE_CAPACITY = "hazelcast.tpc.externalTaskQueue.capacity";
    public static final String NAME_SCHEDULED_TASK_QUEUE_CAPACITY = "hazelcast.tpc.scheduledTaskQueue.capacity";
    public static final String NAME_BATCH_SIZE = "hazelcast.tpc.batch.size";
    public static final String NAME_CLOCK_REFRESH_PERIOD = "hazelcast.tpc.clock.refreshPeriod";
    public static final String NAME_REACTOR_SPIN = "hazelcast.tpc.reactor.spin";
    public static final String NAME_REACTOR_AFFINITY = "hazelcast.tpc.reactor.affinity";
    private static final int DEFAULT_LOCAL_TASK_QUEUE_CAPACITY = 65536;
    private static final int DEFAULT_EXTERNAL_TASK_QUEUE_CAPACITY = 65536;
    private static final int DEFAULT_SCHEDULED_TASK_QUEUE_CAPACITY = 4096;
    private static final int DEFAULT_BATCH_SIZE = 64;
    private static final int DEFAULT_CLOCK_REFRESH_INTERVAL = 16;
    private static final boolean DEFAULT_SPIN = false;
    protected final ReactorType type;
    Supplier<Scheduler> schedulerSupplier = NopScheduler::new;
    Supplier<String> threadNameSupplier;
    Supplier<String> reactorNameSupplier = new Supplier<String>(){
        private final AtomicInteger idGenerator = new AtomicInteger();

        @Override
        public String get() {
            return "Reactor-" + this.idGenerator.incrementAndGet();
        }
    };
    ThreadAffinity threadAffinity = ThreadAffinity.newSystemThreadAffinity("hazelcast.tpc.reactor.affinity");
    ThreadFactory threadFactory = Thread::new;
    boolean spin;
    int localTaskQueueCapacity;
    int externalTaskQueueCapacity;
    int scheduledTaskQueueCapacity;
    int batchSize;
    int clockRefreshPeriod;
    TpcEngine engine;

    protected ReactorBuilder(ReactorType type) {
        this.type = Preconditions.checkNotNull(type);
        this.localTaskQueueCapacity = Integer.getInteger(NAME_LOCAL_TASK_QUEUE_CAPACITY, 65536);
        this.externalTaskQueueCapacity = Integer.getInteger(NAME_EXTERNAL_TASK_QUEUE_CAPACITY, 65536);
        this.scheduledTaskQueueCapacity = Integer.getInteger(NAME_SCHEDULED_TASK_QUEUE_CAPACITY, 4096);
        this.batchSize = Integer.getInteger(NAME_BATCH_SIZE, 64);
        this.clockRefreshPeriod = Integer.getInteger(NAME_CLOCK_REFRESH_PERIOD, 16);
        this.spin = Boolean.parseBoolean(System.getProperty(NAME_REACTOR_SPIN, Boolean.toString(false)));
    }

    public abstract Reactor build();

    public void setReactorNameSupplier(Supplier<String> reactorNameSupplier) {
        this.reactorNameSupplier = Preconditions.checkNotNull(reactorNameSupplier, "reactorNameSupplier");
    }

    public void setClockRefreshPeriod(int clockRefreshPeriod) {
        this.clockRefreshPeriod = Preconditions.checkNotNegative(clockRefreshPeriod, "clockRefreshPeriod");
    }

    public void setThreadFactory(ThreadFactory threadFactory2) {
        this.threadFactory = Preconditions.checkNotNull(threadFactory2, "threadFactory");
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = Preconditions.checkPositive(batchSize, "batchSize");
    }

    public void setThreadNameSupplier(Supplier<String> threadNameSupplier) {
        this.threadNameSupplier = threadNameSupplier;
    }

    public void setThreadAffinity(ThreadAffinity threadAffinity) {
        this.threadAffinity = threadAffinity;
    }

    public void setLocalTaskQueueCapacity(int localTaskQueueCapacity) {
        this.localTaskQueueCapacity = Preconditions.checkPositive(localTaskQueueCapacity, "localTaskQueueCapacity");
    }

    public void setExternalTaskQueueCapacity(int externalTaskQueueCapacity) {
        this.externalTaskQueueCapacity = Preconditions.checkPositive(externalTaskQueueCapacity, "externalTaskQueueCapacity");
    }

    public void setScheduledTaskQueueCapacity(int scheduledTaskQueueCapacity) {
        this.scheduledTaskQueueCapacity = Preconditions.checkPositive(scheduledTaskQueueCapacity, "scheduledTaskQueueCapacity");
    }

    public final void setSpin(boolean spin) {
        this.spin = spin;
    }

    public final void setSchedulerSupplier(Supplier<Scheduler> schedulerSupplier) {
        this.schedulerSupplier = Preconditions.checkNotNull(schedulerSupplier);
    }
}

