/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.PartitionStateVersionMismatchException;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.MigrationPlanner;
import com.hazelcast.internal.partition.impl.MigrationQueue;
import com.hazelcast.internal.partition.impl.MigrationRunnable;
import com.hazelcast.internal.partition.impl.MigrationStats;
import com.hazelcast.internal.partition.impl.MigrationThread;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.FinalizeMigrationOperation;
import com.hazelcast.internal.partition.operation.MigrationCommitOperation;
import com.hazelcast.internal.partition.operation.MigrationRequestOperation;
import com.hazelcast.internal.partition.operation.PromotionCommitOperation;
import com.hazelcast.internal.partition.operation.PublishCompletedMigrationsOperation;
import com.hazelcast.internal.partition.operation.ShutdownResponseOperation;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.internal.util.collection.IntHashSet;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class MigrationManager {
    private static final int MIGRATION_PAUSE_DURATION_SECONDS_ON_MIGRATION_FAILURE = 3;
    private static final int PUBLISH_COMPLETED_MIGRATIONS_BATCH_SIZE = 10;
    private static final int COMMIT_SUCCESS = 1;
    private static final int COMMIT_RETRY = 0;
    private static final int COMMIT_FAILURE = -1;
    final long partitionMigrationInterval;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final InternalPartitionServiceImpl partitionService;
    private final ILogger logger;
    private final PartitionStateManager partitionStateManager;
    private final MigrationQueue migrationQueue = new MigrationQueue();
    private final MigrationThread migrationThread;
    private final AtomicBoolean migrationTasksAllowed = new AtomicBoolean(true);
    private final long partitionMigrationTimeout;
    private final CoalescingDelayedTrigger delayedResumeMigrationTrigger;
    private final Set<Member> shutdownRequestedMembers = new HashSet<Member>();
    private final ConcurrentMap<Integer, MigrationInfo> activeMigrations = new ConcurrentHashMap<Integer, MigrationInfo>();
    private final LinkedHashSet<MigrationInfo> completedMigrations = new LinkedHashSet();
    private final AtomicBoolean promotionPermit = new AtomicBoolean(false);
    private final MigrationStats stats = new MigrationStats();
    private volatile MigrationInterceptor migrationInterceptor = new MigrationInterceptor.NopMigrationInterceptor();
    private final Lock partitionServiceLock;
    private final MigrationPlanner migrationPlanner;
    private final boolean fragmentedMigrationEnabled;
    private final boolean chunkedMigrationEnabled;
    private final int maxTotalChunkedDataInBytes;
    private final long memberHeartbeatTimeoutMillis;
    private boolean triggerRepartitioningWhenClusterStateAllowsMigration;
    private final int maxParallelMigrations;
    private final AtomicInteger migrationCount = new AtomicInteger();
    private final Set<MigrationInfo> finalizingMigrationsRegistry = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Executor asyncExecutor;
    private final int autoRebalanceDelaySeconds;
    private volatile boolean delayNextRepartitioningExecution;
    private volatile ScheduledFuture<Void> scheduledControlTaskFuture;

    MigrationManager(Node node, InternalPartitionServiceImpl service, Lock partitionServiceLock) {
        this.node = node;
        this.nodeEngine = node.getNodeEngine();
        this.partitionService = service;
        this.logger = node.getLogger(this.getClass());
        this.partitionServiceLock = partitionServiceLock;
        this.migrationPlanner = new MigrationPlanner(node.getLogger(MigrationPlanner.class));
        HazelcastProperties properties = node.getProperties();
        this.partitionMigrationInterval = properties.getPositiveMillisOrDefault(ClusterProperty.PARTITION_MIGRATION_INTERVAL, 0L);
        this.partitionMigrationTimeout = properties.getMillis(ClusterProperty.PARTITION_MIGRATION_TIMEOUT);
        this.fragmentedMigrationEnabled = properties.getBoolean(ClusterProperty.PARTITION_FRAGMENTED_MIGRATION_ENABLED);
        this.chunkedMigrationEnabled = properties.getBoolean(ClusterProperty.PARTITION_CHUNKED_MIGRATION_ENABLED);
        this.maxTotalChunkedDataInBytes = (int)MemoryUnit.MEGABYTES.toBytes(properties.getInteger(ClusterProperty.PARTITION_CHUNKED_MAX_MIGRATING_DATA_IN_MB));
        this.maxParallelMigrations = properties.getInteger(ClusterProperty.PARTITION_MAX_PARALLEL_MIGRATIONS);
        this.partitionStateManager = this.partitionService.getPartitionStateManager();
        ILogger migrationThreadLogger = node.getLogger(MigrationThread.class);
        String hzName = this.nodeEngine.getHazelcastInstance().getName();
        this.migrationThread = new MigrationThread(this, hzName, migrationThreadLogger, this.migrationQueue);
        long migrationPauseDelayMs = TimeUnit.SECONDS.toMillis(3L);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        this.delayedResumeMigrationTrigger = new CoalescingDelayedTrigger(executionService, migrationPauseDelayMs, 2L * migrationPauseDelayMs, this::resumeMigration);
        this.memberHeartbeatTimeoutMillis = properties.getMillis(ClusterProperty.MAX_NO_HEARTBEAT_SECONDS);
        this.nodeEngine.getMetricsRegistry().registerStaticMetrics(this.stats, "partitions");
        this.autoRebalanceDelaySeconds = node.getConfig().getPersistenceConfig().isEnabled() ? node.getConfig().getPersistenceConfig().getRebalanceDelaySeconds() : 0;
        this.asyncExecutor = node.getNodeEngine().getExecutionService().getExecutor("hz:async");
    }

    @Probe(name="migrationActive", unit=ProbeUnit.BOOLEAN)
    private int migrationActiveProbe() {
        return this.migrationTasksAllowed.get() ? 1 : 0;
    }

    void pauseMigration() {
        this.migrationTasksAllowed.set(false);
    }

    void resumeMigration() {
        this.migrationTasksAllowed.set(true);
    }

    private void resumeMigrationEventually() {
        this.delayedResumeMigrationTrigger.executeWithDelay();
    }

    boolean areMigrationTasksAllowed() {
        return this.migrationTasksAllowed.get();
    }

    void finalizeMigration(MigrationInfo migrationInfo) {
        try {
            PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
            int partitionId = migrationInfo.getPartitionId();
            boolean source2 = localReplica.equals(migrationInfo.getSource());
            boolean destination = localReplica.equals(migrationInfo.getDestination());
            assert (migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS || migrationInfo.getStatus() == MigrationInfo.MigrationStatus.FAILED) : "Invalid migration: " + migrationInfo;
            if (source2 || destination) {
                MigrationInterceptor.MigrationParticipant participant;
                boolean success = migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS;
                MigrationInterceptor.MigrationParticipant migrationParticipant = participant = source2 ? MigrationInterceptor.MigrationParticipant.SOURCE : MigrationInterceptor.MigrationParticipant.DESTINATION;
                if (success) {
                    this.migrationInterceptor.onMigrationCommit(participant, migrationInfo);
                } else {
                    this.migrationInterceptor.onMigrationRollback(participant, migrationInfo);
                }
                MigrationEndpoint endpoint = source2 ? MigrationEndpoint.SOURCE : MigrationEndpoint.DESTINATION;
                FinalizeMigrationOperation op = new FinalizeMigrationOperation(migrationInfo, endpoint, success);
                op.setPartitionId(partitionId).setNodeEngine(this.nodeEngine).setValidateTarget(false).setService(this.partitionService);
                this.registerFinalizingMigration(migrationInfo);
                OperationServiceImpl operationService = this.nodeEngine.getOperationService();
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Finalizing " + migrationInfo);
                }
                if (operationService.isRunAllowed(op)) {
                    operationService.run(op);
                } else {
                    operationService.execute(op);
                }
                this.removeActiveMigration(migrationInfo);
            } else {
                PartitionReplica partitionOwner = this.partitionStateManager.getPartitionImpl(partitionId).getOwnerReplicaOrNull();
                if (localReplica.equals(partitionOwner)) {
                    this.removeActiveMigration(migrationInfo);
                    this.partitionStateManager.clearMigratingFlag(partitionId);
                } else {
                    this.logger.severe("Failed to finalize migration because " + localReplica + " is not a participant of the migration: " + migrationInfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
    }

    private void registerFinalizingMigration(MigrationInfo migration) {
        this.finalizingMigrationsRegistry.add(migration);
    }

    public boolean isChunkedMigrationEnabled() {
        return this.chunkedMigrationEnabled;
    }

    public int getMaxTotalChunkedDataInBytes() {
        return this.maxTotalChunkedDataInBytes;
    }

    public boolean removeFinalizingMigration(MigrationInfo migration) {
        return this.finalizingMigrationsRegistry.remove(migration);
    }

    public boolean isFinalizingMigrationRegistered(int partitionId) {
        return this.finalizingMigrationsRegistry.stream().anyMatch(m4 -> partitionId == m4.getPartitionId());
    }

    public MigrationInfo addActiveMigration(MigrationInfo migrationInfo) {
        return this.activeMigrations.putIfAbsent(migrationInfo.getPartitionId(), migrationInfo);
    }

    public MigrationInfo getActiveMigration(int partitionId) {
        return (MigrationInfo)this.activeMigrations.get(partitionId);
    }

    public Collection<MigrationInfo> getActiveMigrations() {
        return Collections.unmodifiableCollection(this.activeMigrations.values());
    }

    private boolean removeActiveMigration(MigrationInfo migration) {
        MigrationInfo activeMigration = this.activeMigrations.computeIfPresent(migration.getPartitionId(), (k, currentMigration) -> currentMigration.equals(migration) ? null : currentMigration);
        if (activeMigration != null) {
            this.logger.warning("Active migration could not be removed! Current migration=" + migration + ", active migration=" + activeMigration);
            return false;
        }
        return true;
    }

    public boolean acquirePromotionPermit() {
        return this.promotionPermit.compareAndSet(false, true);
    }

    public void releasePromotionPermit() {
        this.promotionPermit.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleActiveMigrationFinalization(MigrationInfo migrationInfo) {
        this.partitionServiceLock.lock();
        try {
            MigrationInfo activeMigrationInfo = this.getActiveMigration(migrationInfo.getPartitionId());
            if (migrationInfo.equals(activeMigrationInfo)) {
                activeMigrationInfo.setStatus(migrationInfo.getStatus());
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Scheduled finalization of " + activeMigrationInfo);
                }
                this.finalizeMigration(activeMigrationInfo);
                return;
            }
            PartitionReplica source2 = migrationInfo.getSource();
            if (source2 != null && migrationInfo.getSourceCurrentReplicaIndex() > 0 && source2.isIdentical(this.node.getLocalMember())) {
                InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(migrationInfo.getPartitionId());
                if (migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS && migrationInfo.getSourceNewReplicaIndex() != partition.getReplicaIndex(source2)) {
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest("Already finalized " + migrationInfo + " on former backup replica. -> " + partition);
                    }
                    return;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Scheduled finalization of " + migrationInfo + " on former backup replica.");
                }
                this.finalizeMigration(migrationInfo);
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private CompletionStage<Boolean> commitMigrationToDestinationAsync(MigrationInfo migration) {
        PartitionReplica destination = migration.getDestination();
        if (destination.isIdentical(this.node.getLocalMember())) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Shortcutting migration commit, since destination is master. -> " + migration);
            }
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        MemberImpl member = this.node.getClusterService().getMember(destination.address(), destination.uuid());
        if (member == null) {
            this.logger.warning("Cannot commit " + migration + ". Destination " + destination + " is not a member anymore");
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        try {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Sending migration commit operation to " + destination + " for " + migration);
            }
            migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            UUID destinationUuid = member.getUuid();
            MigrationCommitOperation operation = new MigrationCommitOperation(migration, destinationUuid);
            InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination.address()).setTryCount(Integer.MAX_VALUE).setCallTimeout(this.memberHeartbeatTimeoutMillis).invoke();
            return ((CompletableFuture)future.handleAsync((done, t2) -> {
                this.logger.fine("Migration commit response received -> " + migration + ", success: " + done + ", failure: " + t2);
                if (t2 != null) {
                    this.logMigrationCommitFailure(migration, (Throwable)t2);
                    if (t2 instanceof OperationTimeoutException || t2.getCause() instanceof OperationTimeoutException) {
                        return 0;
                    }
                    return -1;
                }
                return done != false ? 1 : -1;
            }, this.asyncExecutor).thenComposeAsync(result -> {
                switch (result) {
                    case 1: {
                        return CompletableFuture.completedFuture(true);
                    }
                    case -1: {
                        return CompletableFuture.completedFuture(false);
                    }
                    case 0: {
                        this.logger.fine("Retrying migration commit for -> " + migration);
                        return this.commitMigrationToDestinationAsync(migration);
                    }
                }
                throw new IllegalArgumentException("Unknown migration commit result: " + result);
            }, this.asyncExecutor)).handleAsync((result, t2) -> {
                if (t2 != null) {
                    this.logMigrationCommitFailure(migration, (Throwable)t2);
                    return false;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Migration commit result " + result + " from " + destination + " for " + migration);
                }
                return result;
            }, this.asyncExecutor);
        }
        catch (Throwable t3) {
            this.logMigrationCommitFailure(migration, t3);
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
    }

    private void logMigrationCommitFailure(MigrationInfo migration, Throwable t2) {
        boolean memberLeft = t2 instanceof MemberLeftException || t2.getCause() instanceof TargetNotMemberException || t2.getCause() instanceof HazelcastInstanceNotActiveException;
        PartitionReplica destination = migration.getDestination();
        if (memberLeft) {
            if (destination.isIdentical(this.node.getLocalMember())) {
                this.logger.fine("Migration commit failed for " + migration + " since this node is shutting down.");
                return;
            }
            this.logger.warning("Migration commit failed for " + migration + " since destination " + destination + " left the cluster");
        } else {
            this.logger.severe("Migration commit to " + destination + " failed for " + migration, t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCompletedMigration(MigrationInfo migrationInfo) {
        if (migrationInfo.getStatus() != MigrationInfo.MigrationStatus.SUCCESS && migrationInfo.getStatus() != MigrationInfo.MigrationStatus.FAILED) {
            throw new IllegalArgumentException("Migration doesn't seem completed: " + migrationInfo);
        }
        if (migrationInfo.getInitialPartitionVersion() <= 0 || migrationInfo.getPartitionVersionIncrement() <= 0) {
            throw new IllegalArgumentException("Partition state versions are not set: " + migrationInfo);
        }
        this.partitionServiceLock.lock();
        try {
            boolean added = this.completedMigrations.add(migrationInfo);
            if (added) {
                this.stats.incrementCompletedMigrations();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    void retainCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.retainAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private void evictCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.removeAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    public void triggerControlTask() {
        this.migrationQueue.clear();
        this.migrationThread.abortMigrationTask();
        if (this.stats.getRemainingMigrations() > 0) {
            this.migrationQueue.add(new PublishCompletedMigrationsTask());
        }
        if (!this.node.getClusterService().isJoined()) {
            this.logger.fine("Node is not joined, will not trigger ControlTask");
            return;
        }
        if (!this.partitionService.isLocalMemberMaster()) {
            this.logger.fine("Node is not master, will not trigger ControlTask");
            return;
        }
        this.migrationQueue.add(new ControlTask());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Migration queue is cleared and control task is scheduled");
        }
    }

    public void triggerControlTaskWithDelay() {
        if (this.autoRebalanceDelaySeconds > 0) {
            this.delayNextRepartitioningExecution = true;
        }
        this.triggerControlTask();
    }

    MigrationInterceptor getMigrationInterceptor() {
        return this.migrationInterceptor;
    }

    void setMigrationInterceptor(MigrationInterceptor interceptor) {
        Preconditions.checkNotNull(interceptor);
        this.migrationInterceptor = interceptor;
    }

    void resetMigrationInterceptor() {
        this.migrationInterceptor = new MigrationInterceptor.NopMigrationInterceptor();
    }

    void onShutdownRequest(Member member) {
        if (!this.partitionStateManager.isInitialized()) {
            this.sendShutdownResponseOperation(member);
            return;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed() && clusterState != ClusterState.IN_TRANSITION) {
            this.sendShutdownResponseOperation(member);
            return;
        }
        if (this.shutdownRequestedMembers.add(member)) {
            this.logger.info("Shutdown request of " + member + " is handled");
            this.triggerControlTask();
        }
    }

    void onMemberRemove(Member member) {
        this.shutdownRequestedMembers.remove(member);
    }

    void schedule(MigrationRunnable runnable2) {
        this.migrationQueue.add(runnable2);
    }

    List<MigrationInfo> getCompletedMigrationsCopy() {
        this.partitionServiceLock.lock();
        try {
            ArrayList<MigrationInfo> arrayList = new ArrayList<MigrationInfo>(this.completedMigrations);
            return arrayList;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MigrationInfo> getCompletedMigrations(int partitionId) {
        this.partitionServiceLock.lock();
        try {
            LinkedList<MigrationInfo> migrations = new LinkedList<MigrationInfo>();
            for (MigrationInfo migration : this.completedMigrations) {
                if (partitionId != migration.getPartitionId()) continue;
                migrations.add(migration);
            }
            LinkedList<MigrationInfo> linkedList = migrations;
            return linkedList;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    boolean hasOnGoingMigration() {
        return !this.activeMigrations.isEmpty() || this.getMigrationQueueSize() > 0;
    }

    int getMigrationQueueSize() {
        int migrations = this.migrationCount.get();
        return migrations + this.migrationQueue.migrationTaskCount();
    }

    void reset() {
        try {
            if (this.scheduledControlTaskFuture != null) {
                this.scheduledControlTaskFuture.cancel(true);
            }
        }
        catch (Throwable t2) {
            this.logger.fine("Cancelling a scheduled control task threw an exception", t2);
        }
        this.migrationQueue.clear();
        this.migrationCount.set(0);
        this.activeMigrations.clear();
        this.completedMigrations.clear();
        this.shutdownRequestedMembers.clear();
        this.migrationTasksAllowed.set(true);
    }

    void start() {
        this.migrationThread.start();
    }

    void stop() {
        this.migrationThread.stopNow();
    }

    void scheduleMigration(MigrationInfo migrationInfo) {
        this.migrationQueue.add(() -> new AsyncMigrationTask(migrationInfo).run().toCompletableFuture().join());
    }

    static void applyMigration(InternalPartitionImpl partition, MigrationInfo migrationInfo) {
        PartitionReplica[] members = partition.getReplicasCopy();
        if (migrationInfo.getSourceCurrentReplicaIndex() > -1) {
            members[migrationInfo.getSourceCurrentReplicaIndex()] = null;
        }
        if (migrationInfo.getDestinationCurrentReplicaIndex() > -1) {
            members[migrationInfo.getDestinationCurrentReplicaIndex()] = null;
        }
        members[migrationInfo.getDestinationNewReplicaIndex()] = migrationInfo.getDestination();
        if (migrationInfo.getSourceNewReplicaIndex() > -1) {
            members[migrationInfo.getSourceNewReplicaIndex()] = migrationInfo.getSource();
        }
        partition.setReplicas(members);
    }

    Set<Member> getShutdownRequestedMembers() {
        return this.shutdownRequestedMembers;
    }

    private void sendShutdownResponseOperation(Member member) {
        if (this.node.getThisAddress().equals(member.getAddress())) {
            assert (!this.node.isRunning()) : "Node state: " + (Object)((Object)this.node.getState());
            this.partitionService.onShutdownResponse();
        } else {
            this.nodeEngine.getOperationService().send(new ShutdownResponseOperation(member.getUuid()), member.getAddress());
        }
    }

    boolean shouldTriggerRepartitioningWhenClusterStateAllowsMigration() {
        return this.triggerRepartitioningWhenClusterStateAllowsMigration;
    }

    private void publishCompletedMigrations() {
        if (!this.partitionService.isLocalMemberMaster()) {
            return;
        }
        assert (this.partitionStateManager.isInitialized());
        List<MigrationInfo> migrations = this.getCompletedMigrationsCopy();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Publishing completed migrations [" + migrations.size() + "]: " + migrations);
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        ClusterServiceImpl clusterService = this.node.clusterService;
        Set<Member> members = clusterService.getMembers();
        AtomicInteger latch = new AtomicInteger(members.size() - 1);
        for (Member member : members) {
            if (member.localMember()) continue;
            PublishCompletedMigrationsOperation operation = new PublishCompletedMigrationsOperation(migrations);
            InvocationFuture f = operationService.invokeOnTarget("hz:core:partitionService", operation, member.getAddress());
            ((CompletableFuture)f).whenCompleteAsync((response, t2) -> {
                if (t2 == null) {
                    if (!Boolean.TRUE.equals(response)) {
                        this.logger.fine(member + " rejected completed migrations with response " + response);
                        this.partitionService.sendPartitionRuntimeState(member.getAddress());
                        return;
                    }
                    if (latch.decrementAndGet() == 0) {
                        this.logger.fine("Evicting " + migrations.size() + " completed migrations.");
                        this.evictCompletedMigrations(migrations);
                    }
                } else {
                    this.logger.fine("Failure while publishing completed migrations to " + member, (Throwable)t2);
                    this.partitionService.sendPartitionRuntimeState(member.getAddress());
                }
            }, this.asyncExecutor);
        }
    }

    public MigrationStats getStats() {
        return this.stats;
    }

    static class PartitionTableViewDistanceComparator
    implements Comparator<PartitionTableView> {
        final PartitionTableView basePartitionTableView;

        PartitionTableViewDistanceComparator(PartitionTableView basePartitionTableView) {
            this.basePartitionTableView = basePartitionTableView;
        }

        @Override
        public int compare(PartitionTableView o1, PartitionTableView o2) {
            return this.distanceFromBase(o1) - this.distanceFromBase(o2);
        }

        int distanceFromBase(PartitionTableView partitionTableView) {
            return partitionTableView.distanceOf(this.basePartitionTableView);
        }
    }

    private class PublishCompletedMigrationsTask
    implements MigrationRunnable {
        private PublishCompletedMigrationsTask() {
        }

        @Override
        public void run() {
            MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationProcessCompletedEvent(MigrationManager.this.stats.toMigrationState());
            MigrationManager.this.publishCompletedMigrations();
        }
    }

    private class ProcessShutdownRequestsTask
    implements MigrationRunnable {
        private ProcessShutdownRequestsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManager.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                int shutdownRequestCount = MigrationManager.this.shutdownRequestedMembers.size();
                if (shutdownRequestCount > 0) {
                    if (shutdownRequestCount == MigrationManager.this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR)) {
                        for (Member member : MigrationManager.this.shutdownRequestedMembers) {
                            MigrationManager.this.sendShutdownResponseOperation(member);
                        }
                    } else {
                        boolean present = false;
                        for (Member member : MigrationManager.this.shutdownRequestedMembers) {
                            if (MigrationManager.this.partitionStateManager.isAbsentInPartitionTable(member)) {
                                MigrationManager.this.sendShutdownResponseOperation(member);
                                continue;
                            }
                            MigrationManager.this.logger.warning(member + " requested to shutdown but still in partition table");
                            present = true;
                        }
                        if (present) {
                            MigrationManager.this.triggerControlTask();
                        }
                    }
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class ControlTask
    implements MigrationRunnable {
        private ControlTask() {
        }

        @Override
        public void run() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.migrationQueue.clear();
                if (MigrationManager.this.partitionService.scheduleFetchMostRecentPartitionTableTaskIfRequired()) {
                    if (MigrationManager.this.logger.isFinestEnabled()) {
                        MigrationManager.this.logger.finest("FetchMostRecentPartitionTableTask scheduled");
                    }
                    MigrationManager.this.migrationQueue.add(new ControlTask());
                    return;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("RepairPartitionTableTask scheduled");
                }
                MigrationManager.this.migrationQueue.add(new RepairPartitionTableTask());
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class RepairPartitionTableTask
    implements MigrationRunnable {
        private RepairPartitionTableTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                return;
            }
            ClusterState clusterState = MigrationManager.this.node.getClusterService().getClusterState();
            if (!clusterState.isMigrationAllowed() && !clusterState.isPartitionPromotionAllowed()) {
                MigrationManager.this.logger.fine("Will not repair partition table at the moment. Cluster state does not allow to modify partition table.");
                return;
            }
            if (MigrationManager.this.delayNextRepartitioningExecution) {
                MigrationManager.this.logger.fine("Delaying next repartitioning execution");
                MigrationManager.this.delayNextRepartitioningExecution = false;
                ExecutionService executionService = MigrationManager.this.nodeEngine.getExecutionService();
                MigrationManager.this.scheduledControlTaskFuture = executionService.schedule(() -> MigrationManager.this.triggerControlTask(), MigrationManager.this.autoRebalanceDelaySeconds, TimeUnit.SECONDS);
                return;
            }
            Map<PartitionReplica, Collection<MigrationInfo>> promotions = this.removeUnknownMembersAndCollectPromotions();
            boolean success = this.promoteBackupsForMissingOwners(promotions);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (success) {
                    if (MigrationManager.this.logger.isFinestEnabled()) {
                        MigrationManager.this.logger.finest("RedoPartitioningTask scheduled");
                    }
                    MigrationManager.this.migrationQueue.add(new RedoPartitioningTask());
                } else {
                    MigrationManager.this.triggerControlTask();
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<PartitionReplica, Collection<MigrationInfo>> removeUnknownMembersAndCollectPromotions() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.partitionStateManager.removeUnknownMembers();
                HashMap<PartitionReplica, Collection<MigrationInfo>> promotions = new HashMap<PartitionReplica, Collection<MigrationInfo>>();
                for (int partitionId = 0; partitionId < MigrationManager.this.partitionService.getPartitionCount(); ++partitionId) {
                    MigrationInfo migration = this.createPromotionMigrationIfOwnerIsNull(partitionId);
                    if (migration == null) continue;
                    Collection migrations = promotions.computeIfAbsent(migration.getDestination(), k -> new ArrayList());
                    migrations.add(migration);
                }
                HashMap<PartitionReplica, Collection<MigrationInfo>> hashMap = promotions;
                return hashMap;
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private boolean promoteBackupsForMissingOwners(Map<PartitionReplica, Collection<MigrationInfo>> promotions) {
            boolean allSucceeded = true;
            for (Map.Entry<PartitionReplica, Collection<MigrationInfo>> entry : promotions.entrySet()) {
                PartitionReplica destination = entry.getKey();
                Collection<MigrationInfo> migrations = entry.getValue();
                allSucceeded &= this.commitPromotionMigrations(destination, migrations);
            }
            return allSucceeded;
        }

        private boolean commitPromotionMigrations(PartitionReplica destination, Collection<MigrationInfo> migrations) {
            MigrationManager.this.migrationInterceptor.onPromotionStart(MigrationInterceptor.MigrationParticipant.MASTER, migrations);
            boolean success = this.commitPromotionsToDestination(destination, migrations);
            boolean local = destination.isIdentical(MigrationManager.this.node.getLocalMember());
            if (!local) {
                this.processPromotionCommitResult(destination, migrations, success);
            }
            MigrationManager.this.migrationInterceptor.onPromotionComplete(MigrationInterceptor.MigrationParticipant.MASTER, migrations, success);
            MigrationManager.this.partitionService.publishPartitionRuntimeState();
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPromotionCommitResult(PartitionReplica destination, Collection<MigrationInfo> migrations, boolean success) {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                    return;
                }
                if (success) {
                    for (MigrationInfo migration : migrations) {
                        InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(migration.getPartitionId());
                        assert (partition.getOwnerReplicaOrNull() == null) : "Owner should be null: " + partition;
                        assert (destination.equals(partition.getReplica(migration.getDestinationCurrentReplicaIndex()))) : "Invalid replica! Destination: " + destination + ", index: " + migration.getDestinationCurrentReplicaIndex() + ", " + partition;
                        partition.swapReplicas(0, migration.getDestinationCurrentReplicaIndex());
                    }
                } else {
                    PartitionStateManager partitionStateManager = MigrationManager.this.partitionService.getPartitionStateManager();
                    for (MigrationInfo migration : migrations) {
                        int delta = migration.getPartitionVersionIncrement() + 1;
                        partitionStateManager.incrementPartitionVersion(migration.getPartitionId(), delta);
                    }
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private MigrationInfo createPromotionMigrationIfOwnerIsNull(int partitionId) {
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId);
            if (partition.getOwnerReplicaOrNull() == null) {
                int index;
                PartitionReplica destination = null;
                for (int i = index = 1; i < 7; ++i) {
                    destination = partition.getReplica(i);
                    if (destination == null) continue;
                    index = i;
                    break;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    if (destination != null) {
                        MigrationManager.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. replicaIndex=" + index + " will be shifted up to 0. " + partition);
                    } else {
                        MigrationManager.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. there is no other replica to shift up. " + partition);
                    }
                }
                if (destination != null) {
                    MigrationInfo migration = new MigrationInfo(partitionId, null, destination, -1, -1, index, 0);
                    migration.setMaster(MigrationManager.this.node.getThisAddress());
                    migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                    migration.setInitialPartitionVersion(partition.version());
                    return migration;
                }
            }
            if (partition.getOwnerReplicaOrNull() == null) {
                MigrationManager.this.logger.warning("partitionId=" + partitionId + " is completely lost!");
                PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
                partitionEventManager.sendPartitionLostEvent(partitionId, 6);
            }
            return null;
        }

        private boolean commitPromotionsToDestination(PartitionReplica destination, Collection<MigrationInfo> migrations) {
            assert (migrations.size() > 0) : "No promotions to commit! destination=" + destination;
            MemberImpl member = MigrationManager.this.node.getClusterService().getMember(destination.address(), destination.uuid());
            if (member == null) {
                MigrationManager.this.logger.warning("Cannot commit promotions. Destination " + destination + " is not a member anymore");
                return false;
            }
            try {
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Sending promotion commit operation to " + destination + " for " + migrations);
                }
                PartitionRuntimeState partitionState = MigrationManager.this.partitionService.createPromotionCommitPartitionState(migrations);
                UUID destinationUuid = member.getUuid();
                PromotionCommitOperation op = new PromotionCommitOperation(partitionState, migrations, destinationUuid);
                InvocationFuture future = MigrationManager.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, destination.address()).setTryCount(Integer.MAX_VALUE).setCallTimeout(MigrationManager.this.memberHeartbeatTimeoutMillis).invoke();
                boolean result = (Boolean)future.get();
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Promotion commit result " + result + " from " + destination + " for migrations " + migrations);
                }
                return result;
            }
            catch (Throwable t2) {
                this.logPromotionCommitFailure(destination, migrations, t2);
                if (t2.getCause() instanceof OperationTimeoutException) {
                    return this.commitPromotionsToDestination(destination, migrations);
                }
                return false;
            }
        }

        private void logPromotionCommitFailure(PartitionReplica destination, Collection<MigrationInfo> migrations, Throwable t2) {
            boolean memberLeft = t2 instanceof MemberLeftException || t2.getCause() instanceof TargetNotMemberException || t2.getCause() instanceof HazelcastInstanceNotActiveException;
            int migrationsSize = migrations.size();
            if (memberLeft) {
                if (destination.isIdentical(MigrationManager.this.node.getLocalMember())) {
                    MigrationManager.this.logger.fine("Promotion commit failed for " + migrationsSize + " migrations since this node is shutting down.");
                    return;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.warning("Promotion commit failed for " + migrations + " since destination " + destination + " left the cluster");
                } else {
                    MigrationManager.this.logger.warning("Promotion commit failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations") + " since destination " + destination + " left the cluster");
                }
                return;
            }
            if (MigrationManager.this.logger.isFinestEnabled()) {
                MigrationManager.this.logger.severe("Promotion commit to " + destination + " failed for " + migrations, t2);
            } else {
                MigrationManager.this.logger.severe("Promotion commit to " + destination + " failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations"), t2);
            }
        }
    }

    private class AsyncMigrationTask {
        private final MigrationInfo migration;

        AsyncMigrationTask(MigrationInfo migration) {
            this.migration = migration;
            migration.setMaster(MigrationManager.this.node.getThisAddress());
        }

        CompletionStage<Boolean> run() {
            if (!MigrationManager.this.partitionService.isLocalMemberMaster()) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            if (this.migration.getSource() == null && this.migration.getDestinationCurrentReplicaIndex() > 0 && this.migration.getDestinationNewReplicaIndex() == 0) {
                throw new IllegalStateException("Promotion migrations must be handled by " + RepairPartitionTableTask.class.getSimpleName() + " -> " + this.migration);
            }
            Member partitionOwner = this.checkMigrationParticipantsAndGetPartitionOwner();
            if (partitionOwner == null) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            return this.executeMigrateOperation(partitionOwner);
        }

        private void beforeMigration() {
            this.migration.setInitialPartitionVersion(MigrationManager.this.partitionStateManager.getPartitionVersion(this.migration.getPartitionId()));
            MigrationManager.this.migrationInterceptor.onMigrationStart(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
            if (MigrationManager.this.logger.isFineEnabled()) {
                MigrationManager.this.logger.fine("Starting Migration: " + this.migration);
            }
        }

        private Member checkMigrationParticipantsAndGetPartitionOwner() {
            Member partitionOwner = this.getPartitionOwner();
            if (partitionOwner == null) {
                MigrationManager.this.logger.fine("Partition owner is null. Ignoring " + this.migration);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            if (this.migration.getSource() != null) {
                PartitionReplica source2 = this.migration.getSource();
                if (MigrationManager.this.node.getClusterService().getMember(source2.address(), source2.uuid()) == null) {
                    MigrationManager.this.logger.fine("Source is not a member anymore. Ignoring " + this.migration);
                    this.triggerRepartitioningAfterMigrationFailure();
                    return null;
                }
            }
            PartitionReplica destination = this.migration.getDestination();
            if (MigrationManager.this.node.getClusterService().getMember(destination.address(), destination.uuid()) == null) {
                MigrationManager.this.logger.fine("Destination is not a member anymore. Ignoring " + this.migration);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            return partitionOwner;
        }

        private Member getPartitionOwner() {
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(this.migration.getPartitionId());
            PartitionReplica owner = partition.getOwnerReplicaOrNull();
            if (owner == null) {
                MigrationManager.this.logger.warning("Skipping migration, since partition owner doesn't exist! -> " + this.migration + ", " + partition);
                return null;
            }
            return MigrationManager.this.node.getClusterService().getMember(owner.address(), owner.uuid());
        }

        private CompletionStage<Boolean> executeMigrateOperation(Member fromMember) {
            InternalCompletableFuture future;
            long start = Timer.nanos();
            try {
                this.beforeMigration();
                List<MigrationInfo> completedMigrations = MigrationManager.this.getCompletedMigrations(this.migration.getPartitionId());
                MigrationRequestOperation op = new MigrationRequestOperation(this.migration, completedMigrations, 0, MigrationManager.this.fragmentedMigrationEnabled, MigrationManager.this.isChunkedMigrationEnabled(), MigrationManager.this.maxTotalChunkedDataInBytes);
                future = MigrationManager.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, fromMember.getAddress()).setCallTimeout(MigrationManager.this.partitionMigrationTimeout).invoke();
            }
            catch (Throwable t3) {
                MigrationManager.this.logger.warning("Error during " + this.migration, t3);
                future = InternalCompletableFuture.completedExceptionally(t3);
            }
            return ((CompletableFuture)((CompletableFuture)future.handleAsync((done, t2) -> {
                MigrationManager.this.stats.recordMigrationOperationTime();
                MigrationManager.this.logger.fine("Migration operation response received -> " + this.migration + ", success: " + done + ", failure: " + t2);
                if (t2 != null) {
                    Level level;
                    Level level2 = level = MigrationManager.this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
                    if (t2 instanceof ExecutionException && t2.getCause() instanceof PartitionStateVersionMismatchException) {
                        level = Level.FINE;
                    }
                    if (MigrationManager.this.logger.isLoggable(level)) {
                        MigrationManager.this.logger.log(level, "Failed migration from " + fromMember + " for " + this.migration, (Throwable)t2);
                    }
                    return Boolean.FALSE;
                }
                return done;
            }, MigrationManager.this.asyncExecutor)).thenComposeAsync(result -> {
                Level level;
                if (result.booleanValue()) {
                    if (MigrationManager.this.logger.isFineEnabled()) {
                        MigrationManager.this.logger.fine("Finished Migration: " + this.migration);
                    }
                    return this.migrationOperationSucceeded();
                }
                Level level2 = level = MigrationManager.this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
                if (MigrationManager.this.logger.isLoggable(level)) {
                    MigrationManager.this.logger.log(level, "Migration failed: " + this.migration);
                }
                this.migrationOperationFailed(fromMember);
                return CompletableFuture.completedFuture(false);
            }, MigrationManager.this.asyncExecutor)).handleAsync((result, t2) -> {
                MigrationManager.this.stats.recordMigrationTaskTime();
                MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationEvent(MigrationManager.this.stats.toMigrationState(), this.migration, TimeUnit.NANOSECONDS.toMillis(Timer.nanosElapsed(start)));
                if (t2 != null) {
                    Level level = MigrationManager.this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
                    MigrationManager.this.logger.log(level, "Error during " + this.migration, (Throwable)t2);
                    return false;
                }
                return result;
            }, MigrationManager.this.asyncExecutor);
        }

        private void migrationOperationFailed(Member partitionOwner) {
            this.migration.setStatus(MigrationInfo.MigrationStatus.FAILED);
            MigrationManager.this.migrationInterceptor.onMigrationComplete(MigrationInterceptor.MigrationParticipant.MASTER, this.migration, false);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.migrationInterceptor.onMigrationRollback(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
                MigrationManager.this.scheduleActiveMigrationFinalization(this.migration);
                int delta = this.migration.getPartitionVersionIncrement() + 1;
                MigrationManager.this.partitionStateManager.incrementPartitionVersion(this.migration.getPartitionId(), delta);
                this.migration.setPartitionVersionIncrement(delta);
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                MigrationManager.this.addCompletedMigration(this.migration);
                if (!partitionOwner.localMember()) {
                    MigrationManager.this.partitionService.sendPartitionRuntimeState(partitionOwner.getAddress());
                }
                if (!this.migration.getDestination().isIdentical(MigrationManager.this.node.getLocalMember())) {
                    MigrationManager.this.partitionService.sendPartitionRuntimeState(this.migration.getDestination().address());
                }
                this.triggerRepartitioningAfterMigrationFailure();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private void triggerRepartitioningAfterMigrationFailure() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.pauseMigration();
                MigrationManager.this.triggerControlTask();
                MigrationManager.this.resumeMigrationEventually();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private CompletionStage<Boolean> migrationOperationSucceeded() {
            MigrationManager.this.migrationInterceptor.onMigrationComplete(MigrationInterceptor.MigrationParticipant.MASTER, this.migration, true);
            CompletionStage<Boolean> f = MigrationManager.this.commitMigrationToDestinationAsync(this.migration);
            f = f.thenApplyAsync(commitSuccessful -> {
                MigrationManager.this.stats.recordDestinationCommitTime();
                MigrationManager.this.partitionServiceLock.lock();
                try {
                    InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(this.migration.getPartitionId());
                    assert (this.migration.getInitialPartitionVersion() == partition.version()) : "Migration initial version: " + this.migration.getInitialPartitionVersion() + ", Partition version: " + partition.version();
                    if (commitSuccessful.booleanValue()) {
                        this.migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                        MigrationManager.this.migrationInterceptor.onMigrationCommit(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
                        MigrationManager.applyMigration(partition, this.migration);
                    } else {
                        this.migration.setStatus(MigrationInfo.MigrationStatus.FAILED);
                        MigrationManager.this.migrationInterceptor.onMigrationRollback(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
                        int delta = this.migration.getPartitionVersionIncrement() + 1;
                        this.migration.setPartitionVersionIncrement(delta);
                        MigrationManager.this.partitionStateManager.incrementPartitionVersion(partition.getPartitionId(), delta);
                        if (!this.migration.getDestination().isIdentical(MigrationManager.this.node.getLocalMember())) {
                            MigrationManager.this.partitionService.sendPartitionRuntimeState(this.migration.getDestination().address());
                        }
                        this.triggerRepartitioningAfterMigrationFailure();
                    }
                    assert (this.migration.getFinalPartitionVersion() == partition.version()) : "Migration final version: " + this.migration.getFinalPartitionVersion() + ", Partition version: " + partition.version();
                    MigrationManager.this.addCompletedMigration(this.migration);
                    MigrationManager.this.scheduleActiveMigrationFinalization(this.migration);
                    MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                    if (MigrationManager.this.completedMigrations.size() >= 10) {
                        MigrationManager.this.publishCompletedMigrations();
                    }
                }
                finally {
                    MigrationManager.this.partitionServiceLock.unlock();
                }
                return commitSuccessful;
            }, MigrationManager.this.asyncExecutor);
            return f;
        }
    }

    class MigrationPlanTask
    implements MigrationRunnable {
        private final List<Queue<MigrationInfo>> partitionMigrationQueues;
        private final BlockingQueue<MigrationInfo> completed;
        private final IntHashSet migratingPartitions;
        private final Map<Address, Integer> endpoint2MigrationCount = new HashMap<Address, Integer>();
        private int ongoingMigrationCount;
        private boolean failed;
        private volatile boolean aborted;

        MigrationPlanTask(List<Queue<MigrationInfo>> partitionMigrationQueues) {
            this.partitionMigrationQueues = partitionMigrationQueues;
            this.completed = new ArrayBlockingQueue<MigrationInfo>(partitionMigrationQueues.size());
            this.migratingPartitions = new IntHashSet(partitionMigrationQueues.stream().mapToInt(Collection::size).sum(), -1);
        }

        @Override
        public void run() {
            MigrationInfo migration;
            MigrationManager.this.migrationCount.set(this.partitionMigrationQueues.stream().mapToInt(Collection::size).sum());
            while ((migration = this.next()) != null && !(this.failed | this.aborted)) {
                block5: {
                    this.onStart(migration);
                    try {
                        CompletionStage<Boolean> f = new AsyncMigrationTask(migration).run();
                        f.thenRunAsync(() -> {
                            MigrationManager.this.logger.fine("AsyncMigrationTask completed: " + migration);
                            boolean offered = this.completed.offer(migration);
                            assert (offered) : "Failed to offer completed migration: " + migration;
                        }, ConcurrencyUtil.CALLER_RUNS);
                    }
                    catch (Throwable e) {
                        MigrationManager.this.logger.warning("AsyncMigrationTask failed: " + migration, e);
                        boolean offered = this.completed.offer(migration);
                        if ($assertionsDisabled || offered) break block5;
                        throw new AssertionError((Object)("Failed to offer completed migration: " + migration));
                    }
                }
                if (this.migrationDelay()) continue;
                break;
            }
            this.waitOngoingMigrations();
            if (this.failed || this.aborted) {
                MigrationManager.this.logger.info("Rebalance process was " + (this.failed ? "failed" : "aborted") + ". Ignoring remaining migrations. Will recalculate the new migration plan. (" + MigrationManager.this.stats.formatToString(MigrationManager.this.logger.isFineEnabled()) + ")");
                MigrationManager.this.migrationCount.set(0);
                this.partitionMigrationQueues.clear();
            } else {
                MigrationManager.this.logger.info("All migration tasks have been completed. (" + MigrationManager.this.stats.formatToString(MigrationManager.this.logger.isFineEnabled()) + ")");
            }
        }

        private void onStart(MigrationInfo migration) {
            boolean added = this.migratingPartitions.add(migration.getPartitionId());
            assert (added) : "Couldn't add partitionId to migrating partitions set: " + migration;
            BiFunction<Address, Integer, Integer> inc = (address, current) -> current != null ? current + 1 : 1;
            int count = this.endpoint2MigrationCount.compute(migration.getDestinationAddress(), inc);
            assert (count > 0 && count <= MigrationManager.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            count = this.endpoint2MigrationCount.compute(this.sourceAddress(migration), inc);
            assert (count > 0 && count <= MigrationManager.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            ++this.ongoingMigrationCount;
            MigrationManager.this.migrationCount.decrementAndGet();
        }

        private void onComplete(MigrationInfo migration) {
            boolean removed = this.migratingPartitions.remove(migration.getPartitionId());
            assert (removed) : "Couldn't remove partitionId from migrating partitions set: " + migration;
            BiFunction<Address, Integer, Integer> dec = (address, current) -> current != null ? current - 1 : -1;
            long count = this.endpoint2MigrationCount.compute(migration.getDestinationAddress(), dec).intValue();
            assert (count >= 0L && count < (long)MigrationManager.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            count = this.endpoint2MigrationCount.compute(this.sourceAddress(migration), dec).intValue();
            assert (count >= 0L && count < (long)MigrationManager.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            if (migration.getStatus() != MigrationInfo.MigrationStatus.SUCCESS) {
                this.failed = true;
            }
            --this.ongoingMigrationCount;
        }

        private boolean processCompleted() {
            MigrationInfo migration;
            boolean ok = false;
            while ((migration = (MigrationInfo)this.completed.poll()) != null) {
                this.onComplete(migration);
                ok = true;
            }
            return ok;
        }

        private MigrationInfo next() {
            MigrationInfo m4;
            while ((m4 = this.next0()) == null && !this.partitionMigrationQueues.isEmpty()) {
                if (!this.processCompleted()) {
                    try {
                        MigrationInfo migration = this.completed.take();
                        this.onComplete(migration);
                    }
                    catch (InterruptedException e) {
                        this.onInterrupted(e);
                        break;
                    }
                }
                if (!(this.failed | this.aborted)) continue;
                break;
            }
            return m4;
        }

        private MigrationInfo next0() {
            Iterator<Queue<MigrationInfo>> iter = this.partitionMigrationQueues.iterator();
            while (iter.hasNext()) {
                Queue<MigrationInfo> q = iter.next();
                if (q.isEmpty()) {
                    iter.remove();
                    continue;
                }
                if (!this.select(q.peek())) continue;
                return q.poll();
            }
            return null;
        }

        private boolean select(MigrationInfo m4) {
            if (m4 == null) {
                return true;
            }
            if (this.migratingPartitions.contains(m4.getPartitionId())) {
                return false;
            }
            if (this.endpoint2MigrationCount.getOrDefault(m4.getDestinationAddress(), 0) == MigrationManager.this.maxParallelMigrations) {
                return false;
            }
            return this.endpoint2MigrationCount.getOrDefault(this.sourceAddress(m4), 0) < MigrationManager.this.maxParallelMigrations;
        }

        private Address sourceAddress(MigrationInfo m4) {
            if (m4.getSourceCurrentReplicaIndex() == 0) {
                return m4.getSourceAddress();
            }
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(m4.getPartitionId());
            return partition.getOwnerOrNull();
        }

        private boolean migrationDelay() {
            if (MigrationManager.this.partitionMigrationInterval > 0L) {
                try {
                    Thread.sleep(MigrationManager.this.partitionMigrationInterval);
                }
                catch (InterruptedException e) {
                    this.onInterrupted(e);
                    return false;
                }
            }
            return true;
        }

        private void waitOngoingMigrations() {
            boolean interrupted = false;
            while (this.ongoingMigrationCount > 0) {
                try {
                    MigrationInfo migration = this.completed.take();
                    this.onComplete(migration);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        private void onInterrupted(InterruptedException e) {
            MigrationManager.this.logger.info("MigrationProcessTask is interrupted! Ignoring remaining migrations...", e);
            Thread.currentThread().interrupt();
            this.abort();
        }

        void abort() {
            this.aborted = true;
        }
    }

    class RedoPartitioningTask
    implements MigrationRunnable {
        RedoPartitioningTask() {
        }

        @Override
        public void run() {
            if (!MigrationManager.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.triggerRepartitioningWhenClusterStateAllowsMigration = !MigrationManager.this.node.getClusterService().getClusterState().isMigrationAllowed();
                if (MigrationManager.this.triggerRepartitioningWhenClusterStateAllowsMigration) {
                    if (MigrationManager.this.logger.isFineEnabled()) {
                        MigrationManager.this.logger.fine("Migrations are not allowed yet, repartitioning will be triggered when cluster state allows migrations.");
                    }
                    this.assignCompletelyLostPartitions();
                    return;
                }
                PartitionReplica[][] newState = this.repartition();
                if (newState == null) {
                    return;
                }
                this.processNewPartitionState(newState);
                MigrationManager.this.migrationQueue.add(new ProcessShutdownRequestsTask());
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private PartitionReplica[][] repartition() {
            if (!this.migrationsTasksAllowed()) {
                return null;
            }
            PartitionReplica[][] newState = null;
            if (MigrationManager.this.node.getNodeExtension().getInternalHotRestartService().isEnabled()) {
                newState = this.checkSnapshots();
            }
            if (newState != null) {
                MigrationManager.this.logger.info("Identified a snapshot of left member for repartition");
            } else {
                newState = MigrationManager.this.partitionStateManager.repartition(MigrationManager.this.shutdownRequestedMembers, null);
            }
            if (newState == null) {
                MigrationManager.this.migrationQueue.add(new ProcessShutdownRequestsTask());
                return null;
            }
            if (!this.migrationsTasksAllowed()) {
                return null;
            }
            return newState;
        }

        PartitionReplica[][] checkSnapshots() {
            HashSet<UUID> shutdownRequestedReplicas = new HashSet<UUID>();
            HashSet<UUID> currentReplicas = new HashSet<UUID>();
            HashMap<UUID, Address> currentAddressMapping = new HashMap<UUID, Address>();
            MigrationManager.this.shutdownRequestedMembers.forEach(member -> shutdownRequestedReplicas.add(member.getUuid()));
            Collection<Member> currentMembers = MigrationManager.this.node.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
            currentMembers.forEach(member -> currentReplicas.add(member.getUuid()));
            currentMembers.forEach(member -> currentAddressMapping.put(member.getUuid(), member.getAddress()));
            TreeSet<PartitionTableView> candidates = new TreeSet<PartitionTableView>(new PartitionTableViewDistanceComparator(MigrationManager.this.partitionStateManager.getPartitionTable()));
            for (PartitionTableView partitionTableView : MigrationManager.this.partitionStateManager.snapshots()) {
                if (!partitionTableView.composedOf(currentReplicas, shutdownRequestedReplicas)) continue;
                candidates.add(partitionTableView);
            }
            if (candidates.isEmpty()) {
                return null;
            }
            return ((PartitionTableView)candidates.iterator().next()).toArray(currentAddressMapping);
        }

        private void assignCompletelyLostPartitions() {
            if (!MigrationManager.this.node.getClusterService().getClusterState().isPartitionPromotionAllowed()) {
                return;
            }
            MigrationManager.this.logger.fine("Cluster state doesn't allow repartitioning. RedoPartitioningTask will only assign lost partitions.");
            InternalPartition[] partitions = MigrationManager.this.partitionStateManager.getPartitions();
            PartitionIdSet partitionIds = Arrays.stream(partitions).filter(p -> InternalPartition.replicaIndices().allMatch(i -> p.getReplica(i) == null)).map(IPartition::getPartitionId).collect(Collectors.toCollection(() -> new PartitionIdSet(partitions.length)));
            if (!partitionIds.isEmpty()) {
                PartitionReplica[][] state = MigrationManager.this.partitionStateManager.repartition(MigrationManager.this.shutdownRequestedMembers, partitionIds);
                if (state != null) {
                    MigrationManager.this.logger.warning("Assigning new owners for " + partitionIds.size() + " LOST partitions, when migration is not allowed!");
                    int replicaUpdateCount = (int)partitionIds.stream().flatMap(partitionId -> Arrays.stream(state[partitionId]).filter(Objects::nonNull)).count();
                    MigrationStateImpl[] states = new MigrationStateImpl[]{new MigrationStateImpl(Clock.currentTimeMillis(), replicaUpdateCount, 0, 0L)};
                    PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
                    partitionEventManager.sendMigrationProcessStartedEvent(states[0]);
                    partitionIds.intIterator().forEachRemaining(partitionId -> {
                        InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId);
                        PartitionReplica[] replicas = state[partitionId];
                        partition.setReplicas(replicas);
                        InternalPartition.replicaIndices().filter(i -> replicas[i] != null).forEach(i -> {
                            MigrationInfo migration = new MigrationInfo(partitionId, null, replicas[i], -1, -1, -1, i).setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                            states[0] = states[0].onComplete(0L);
                            partitionEventManager.sendMigrationEvent(states[0], migration, 0L);
                        });
                    });
                    partitionEventManager.sendMigrationProcessCompletedEvent(states[0]);
                    MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                } else {
                    MigrationManager.this.logger.warning("Unable to assign LOST partitions");
                }
            }
        }

        private void processNewPartitionState(PartitionReplica[][] newState) {
            int migrationCount = 0;
            ArrayList<Queue<MigrationInfo>> partitionMigrationQueues = new ArrayList<Queue<MigrationInfo>>(newState.length);
            Int2ObjectHashMap<PartitionReplica> lostPartitions = new Int2ObjectHashMap<PartitionReplica>();
            for (int partitionId2 = 0; partitionId2 < newState.length; ++partitionId2) {
                InternalPartitionImpl currentPartition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId2);
                Object[] currentReplicas = currentPartition.replicas();
                Object[] newReplicas = newState[partitionId2];
                MigrationCollector migrationCollector = new MigrationCollector(currentPartition);
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Planning migrations for partitionId=" + partitionId2 + ". Current replicas: " + Arrays.toString(currentReplicas) + ", New replicas: " + Arrays.toString(newReplicas));
                }
                MigrationManager.this.migrationPlanner.planMigrations(partitionId2, (PartitionReplica[])currentReplicas, (PartitionReplica[])newReplicas, migrationCollector);
                MigrationManager.this.migrationPlanner.prioritizeCopiesAndShiftUps(migrationCollector.migrations);
                if (migrationCollector.lostPartitionDestination != null) {
                    lostPartitions.put(partitionId2, migrationCollector.lostPartitionDestination);
                }
                if (migrationCollector.migrations.isEmpty()) continue;
                partitionMigrationQueues.add(migrationCollector.migrations);
                migrationCount += migrationCollector.migrations.size();
            }
            MigrationManager.this.stats.markNewRepartition(migrationCount);
            if (migrationCount > 0) {
                MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationProcessStartedEvent(MigrationManager.this.stats.toMigrationState());
            }
            if (!lostPartitions.isEmpty()) {
                MigrationManager.this.logger.warning("Assigning new owners for " + lostPartitions.size() + " LOST partitions!");
                lostPartitions.forEach((partitionId, destination) -> {
                    InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl((int)partitionId);
                    this.assignLostPartitionOwner(partition, (PartitionReplica)destination);
                });
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
            }
            MigrationManager.this.partitionService.publishPartitionRuntimeState();
            if (migrationCount > 0) {
                this.scheduleMigrations(partitionMigrationQueues);
                MigrationManager.this.schedule(new PublishCompletedMigrationsTask());
            }
            this.logMigrationStatistics(migrationCount);
        }

        private void scheduleMigrations(List<Queue<MigrationInfo>> partitionMigrationQueues) {
            MigrationManager.this.schedule(new MigrationPlanTask(partitionMigrationQueues));
        }

        private void logMigrationStatistics(int migrationCount) {
            if (migrationCount > 0) {
                MigrationManager.this.logger.info("Repartitioning cluster data. Migration tasks count: " + migrationCount);
            } else {
                MigrationManager.this.logger.info("Partition balance is ok, no need to repartition.");
            }
        }

        private void assignLostPartitionOwner(InternalPartitionImpl partition, PartitionReplica newOwner) {
            partition.setReplica(0, newOwner);
            MigrationManager.this.stats.incrementCompletedMigrations();
            MigrationInfo migrationInfo = new MigrationInfo(partition.getPartitionId(), null, newOwner, -1, -1, -1, 0);
            migrationInfo.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationEvent(MigrationManager.this.stats.toMigrationState(), migrationInfo, 0L);
        }

        private boolean migrationsTasksAllowed() {
            boolean hasMigrationTasks;
            boolean migrationTasksAllowed = MigrationManager.this.areMigrationTasksAllowed();
            boolean bl = hasMigrationTasks = MigrationManager.this.migrationQueue.migrationTaskCount() > 1;
            if (migrationTasksAllowed && !hasMigrationTasks) {
                return true;
            }
            MigrationManager.this.triggerControlTask();
            return false;
        }

        private class MigrationCollector
        implements MigrationPlanner.MigrationDecisionCallback {
            private final InternalPartitionImpl partition;
            private final LinkedList<MigrationInfo> migrations = new LinkedList();
            private PartitionReplica lostPartitionDestination;

            MigrationCollector(InternalPartitionImpl partition) {
                this.partition = partition;
            }

            @Override
            public void migrate(PartitionReplica source2, int sourceCurrentReplicaIndex, int sourceNewReplicaIndex, PartitionReplica destination, int destinationCurrentReplicaIndex, int destinationNewReplicaIndex) {
                int partitionId = this.partition.getPartitionId();
                if (MigrationManager.this.logger.isFineEnabled()) {
                    MigrationManager.this.logger.fine("Planned migration -> partitionId=" + partitionId + ", source=" + source2 + ", sourceCurrentReplicaIndex=" + sourceCurrentReplicaIndex + ", sourceNewReplicaIndex=" + sourceNewReplicaIndex + ", destination=" + destination + ", destinationCurrentReplicaIndex=" + destinationCurrentReplicaIndex + ", destinationNewReplicaIndex=" + destinationNewReplicaIndex);
                }
                if (source2 == null && destinationCurrentReplicaIndex == -1 && destinationNewReplicaIndex == 0) {
                    assert (destination != null) : "partitionId=" + partitionId + " destination is null";
                    assert (sourceCurrentReplicaIndex == -1) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceNewReplicaIndex == -1) : "partitionId=" + partitionId + " invalid index: " + sourceNewReplicaIndex;
                    assert (this.lostPartitionDestination == null) : "Current: " + this.lostPartitionDestination + ", New: " + destination;
                    this.lostPartitionDestination = destination;
                } else if (destination == null && sourceNewReplicaIndex == -1) {
                    assert (source2 != null) : "partitionId=" + partitionId + " source is null";
                    assert (sourceCurrentReplicaIndex != -1) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceCurrentReplicaIndex != 0) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    PartitionReplica currentSource = this.partition.getReplica(sourceCurrentReplicaIndex);
                    assert (source2.equals(currentSource)) : "partitionId=" + partitionId + " current source=" + source2 + " is different than expected source=" + source2;
                    this.partition.setReplica(sourceCurrentReplicaIndex, null);
                } else {
                    MigrationInfo migration = new MigrationInfo(partitionId, source2, destination, sourceCurrentReplicaIndex, sourceNewReplicaIndex, destinationCurrentReplicaIndex, destinationNewReplicaIndex);
                    this.migrations.add(migration);
                }
            }
        }
    }
}

