/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.Metric;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.MetricValueCatcher;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeInstance;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractGauge
implements Metric {
    protected final MetricsRegistryImpl metricsRegistry;
    protected final String name;
    protected long lastCollectionId = Long.MIN_VALUE;

    AbstractGauge(MetricsRegistryImpl metricsRegistry, String name) {
        this.metricsRegistry = metricsRegistry;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract void onProbeInstanceSet(ProbeInstance var1);

    abstract MetricValueCatcher getCatcherOrNull();

    final void onCollectionCompleted(long collectionId) {
        MetricValueCatcher catcher;
        if (this.lastCollectionId != collectionId && (catcher = this.getCatcherOrNull()) != null && catcher instanceof AbstractMetricValueCatcher) {
            ((AbstractMetricValueCatcher)catcher).clearCachedValue();
            ((AbstractMetricValueCatcher)catcher).clearCachedMetricSourceRef();
        }
    }

    @FunctionalInterface
    static interface MetricCachedValueReaderFunction<T> {
        public T readCachedValue();
    }

    @FunctionalInterface
    static interface MetricValueExtractorFunction<T> {
        public T extractValue(String var1, Object var2, ProbeFunction var3, MetricsRegistryImpl var4);
    }

    private static final class DynamicMetricSourceReference {
        private final WeakReference<Object> sourceRef;
        private final WeakReference<ProbeFunction> functionRef;

        DynamicMetricSourceReference(Object source2, ProbeFunction function) {
            this.sourceRef = new WeakReference<Object>(source2);
            this.functionRef = new WeakReference<ProbeFunction>(function);
        }

        Object source() {
            return this.sourceRef.get();
        }

        ProbeFunction function() {
            return (ProbeFunction)this.functionRef.get();
        }
    }

    abstract class AbstractMetricValueCatcher
    implements MetricValueCatcher {
        private final AtomicReference<DynamicMetricSourceReference> dynamicMetricRef = new AtomicReference();

        AbstractMetricValueCatcher() {
        }

        @Override
        public final void catchMetricValue(long collectionId, Object source2, ProbeFunction function) {
            AbstractGauge.this.lastCollectionId = collectionId;
            if (function == null || source2 == null) {
                this.clearCachedValue();
            } else {
                DynamicMetricSourceReference cachedMetricRef = this.dynamicMetricRef.get();
                if (cachedMetricRef == null || source2 != cachedMetricRef.source() || function != cachedMetricRef.function()) {
                    this.dynamicMetricRef.set(new DynamicMetricSourceReference(source2, function));
                    this.clearCachedValue();
                }
            }
        }

        final <T> T readBase(MetricValueExtractorFunction<T> extractorFn, MetricCachedValueReaderFunction<T> readCachedFn) {
            DynamicMetricSourceReference cachedMetricRef = this.dynamicMetricRef.get();
            if (cachedMetricRef != null) {
                Object source2 = cachedMetricRef.source();
                ProbeFunction function = cachedMetricRef.function();
                if (source2 != null && function != null) {
                    return extractorFn.extractValue(AbstractGauge.this.name, source2, function, AbstractGauge.this.metricsRegistry);
                }
                this.clearCachedMetricSourceRef();
            }
            return readCachedFn.readCachedValue();
        }

        abstract void clearCachedValue();

        final void clearCachedMetricSourceRef() {
            this.dynamicMetricRef.lazySet(null);
        }
    }
}

