/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport.operations;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.locksupport.LockWaitNotifyKey;
import com.hazelcast.internal.locksupport.operations.AbstractLockOperation;
import com.hazelcast.internal.locksupport.operations.LockBackupOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import java.io.Serializable;

public class LockOperation
extends AbstractLockOperation
implements BlockingOperation,
BackupAwareOperation,
MutatingOperation {
    public LockOperation() {
    }

    public LockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout2) {
        super(namespace, key, threadId, leaseTime, timeout2);
    }

    public LockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout2, long referenceId, boolean isClient) {
        super(namespace, key, threadId, leaseTime, timeout2);
        this.isClient = isClient;
        this.setReferenceCallId(referenceId);
    }

    @Override
    public void run() throws Exception {
        this.interceptLockOperation();
        if (this.isClient) {
            ClientEngine clientEngine = (ClientEngine)this.getNodeEngine().getService("hz:core:clientEngine");
            clientEngine.onClientAcquiredResource(this.getCallerUuid());
        }
        boolean lockResult = this.getLockStore().lock(this.key, this.getCallerUuid(), this.threadId, this.getReferenceCallId(), this.leaseTime);
        this.response = lockResult;
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            if (lockResult) {
                logger2.finest("Acquired lock " + this.namespace.getObjectName() + " for " + this.getCallerAddress() + " - " + this.getCallerUuid() + ", thread ID: " + this.threadId);
            } else {
                logger2.finest("Could not acquire lock " + this.namespace.getObjectName() + " as owned by " + this.getLockStore().getOwnerInfo(this.key));
            }
        }
    }

    @Override
    public Operation getBackupOperation() {
        LockBackupOperation operation = new LockBackupOperation(this.namespace, this.key, this.threadId, this.leaseTime, this.getCallerUuid(), this.isClient);
        operation.setReferenceCallId(this.getReferenceCallId());
        return operation;
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public final WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(this.namespace, this.key);
    }

    @Override
    public final boolean shouldWait() {
        LockStoreImpl lockStore = this.getLockStore();
        return this.getWaitTimeout() != 0L && !lockStore.canAcquireLock(this.key, this.getCallerUuid(), this.threadId);
    }

    @Override
    public final void onWaitExpire() {
        long timeout2 = this.getWaitTimeout();
        Serializable response = timeout2 < 0L || timeout2 == Long.MAX_VALUE ? new OperationTimeoutException() : Boolean.FALSE;
        this.sendResponse(response);
    }

    @Override
    public int getClassId() {
        return 11;
    }
}

