/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl.hazelcastdataconnection;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.StringUtil;

public class HazelcastDataConnectionConfigValidator {
    public void validate(DataConnectionConfig dataConnectionConfig) {
        int numberOfSetItems = this.getNumberOfSetItems(dataConnectionConfig, "client_xml_path", "client_yml_path", "client_xml", "client_yml");
        if (numberOfSetItems != 1) {
            throw new HazelcastException("HazelcastDataConnection with name '" + dataConnectionConfig.getName() + "' could not be created, provide either a file path with one of \"client_xml_path\" or \"client_yml_path\" properties or a string content with one of \"client_xml\" or \"client_yml\" properties for the client configuration.");
        }
    }

    private int getNumberOfSetItems(DataConnectionConfig dataConnectionConfig, String ... properties) {
        int count = 0;
        for (String property : properties) {
            if (!this.isSetAfterTrim(dataConnectionConfig.getProperty(property))) continue;
            ++count;
        }
        return count;
    }

    private boolean isSetAfterTrim(String s2) {
        return !StringUtil.isNullOrEmptyAfterTrim(s2);
    }
}

