/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.custom.CapacityCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemoryTierConfigCodec;
import com.hazelcast.config.BTreeIndexConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.memory.Capacity;

public final class BTreeIndexConfigCodec {
    private BTreeIndexConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, BTreeIndexConfig bTreeIndexConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        CapacityCodec.encode(clientMessage, bTreeIndexConfig.getPageSize());
        MemoryTierConfigCodec.encode(clientMessage, bTreeIndexConfig.getMemoryTierConfig());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static BTreeIndexConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        Capacity pageSize = CapacityCodec.decode(iterator2);
        MemoryTierConfig memoryTierConfig = MemoryTierConfigCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createBTreeIndexConfig(pageSize, memoryTierConfig);
    }
}

