/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

public class HostAddress {
    public String host;
    public int port;

    public static HostAddress[] parse(String spec) {
        String[] tokens = spec.split(",");
        HostAddress[] arr = new HostAddress[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            arr[i] = HostAddress.parseSingleHostAddress(tokens[i]);
        }
        int defaultPort = arr[arr.length - 1].port;
        if (defaultPort == 0) {
            defaultPort = 3306;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].port != 0) continue;
            arr[i].port = defaultPort;
        }
        return arr;
    }

    static HostAddress parseSingleHostAddress(String s2) {
        HostAddress result = new HostAddress();
        if (s2.startsWith("[")) {
            int ind = s2.indexOf(93);
            result.host = s2.substring(1, ind);
            if (ind != s2.length() - 1 && s2.charAt(ind + 1) == ':') {
                result.port = Integer.parseInt(s2.substring(ind + 2));
            }
        } else if (s2.contains(":")) {
            String[] hostPort = s2.split(":");
            result.host = hostPort[0];
            result.port = Integer.parseInt(hostPort[1]);
        } else {
            result.host = s2;
        }
        return result;
    }

    public static String toString(HostAddress[] addrs) {
        String s2 = "";
        for (int i = 0; i < addrs.length; ++i) {
            boolean isIPv6 = addrs[i].host != null && addrs[i].host.contains(":");
            String host = isIPv6 ? "[" + addrs[i].host + "]" : addrs[i].host;
            s2 = s2 + host + ":" + addrs[i].port;
            if (i >= addrs.length - 1) continue;
            s2 = s2 + ",";
        }
        return s2;
    }
}

