/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.client.ClientRequest;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.TruncatedResponseException;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

final class HttpRequestConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final Logger log = Logger.getLogger("io.undertow.client.request");
    private final ByteBufferPool pool;
    private volatile int state = 2;
    private Iterator<HttpString> nameIterator;
    private String string;
    private HttpString headerName;
    private Iterator<String> valueIterator;
    private int charIndex;
    private PooledByteBuffer pooledBuffer;
    private final ClientRequest request;
    private static final int STATE_BODY = 0;
    private static final int STATE_URL = 1;
    private static final int STATE_START = 2;
    private static final int STATE_HDR_NAME = 3;
    private static final int STATE_HDR_D = 4;
    private static final int STATE_HDR_DS = 5;
    private static final int STATE_HDR_VAL = 6;
    private static final int STATE_HDR_EOL_CR = 7;
    private static final int STATE_HDR_EOL_LF = 8;
    private static final int STATE_HDR_FINAL_CR = 9;
    private static final int STATE_HDR_FINAL_LF = 10;
    private static final int STATE_BUF_FLUSH = 11;
    private static final int MASK_STATE = 15;
    private static final int FLAG_SHUTDOWN = 16;
    private static final int FLAG_WRITING = 32;
    private static final AtomicIntegerFieldUpdater<HttpRequestConduit> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpRequestConduit.class, "state");

    HttpRequestConduit(StreamSinkConduit next, ByteBufferPool pool, ClientRequest request) {
        super(next);
        this.pool = pool;
        this.request = request;
    }

    private int processWrite(int state, ByteBuffer userData) throws IOException {
        return this.doProcessWrite(state, userData);
    }

    /*
     * Unable to fully structure code
     */
    private int doProcessWrite(int state, ByteBuffer userData) throws IOException {
        if (state == 2) {
            this.pooledBuffer = this.pool.allocate();
        }
        request = this.request;
        buffer = this.pooledBuffer.getBuffer();
        if (state != 2 && buffer.hasRemaining()) {
            HttpRequestConduit.log.trace("Flushing remaining buffer");
            do {
                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                return state;
            } while (buffer.hasRemaining());
        }
        buffer.clear();
        block15: while (true) {
            switch (state) {
                case 0: {
                    return state;
                }
                case 2: {
                    HttpRequestConduit.log.trace("Starting request");
                    len = request.getMethod().length() + request.getPath().length() + request.getProtocol().length() + 4;
                    if (len <= buffer.remaining()) {
                        if (!HttpRequestConduit.$assertionsDisabled && buffer.remaining() < 50) {
                            throw new AssertionError();
                        }
                        request.getMethod().appendTo(buffer);
                        buffer.put((byte)32);
                        this.string = request.getPath();
                        length = this.string.length();
                        this.charIndex = 0;
                        while (this.charIndex < length) {
                            buffer.put((byte)this.string.charAt(this.charIndex));
                            ++this.charIndex;
                        }
                    } else {
                        sb = new StringBuilder(len);
                        sb.append(request.getMethod().toString());
                        sb.append(" ");
                        sb.append(request.getPath());
                        sb.append(" ");
                        sb.append(request.getProtocol());
                        sb.append("\r\n");
                        this.string = sb.toString();
                        this.charIndex = 0;
                        state = 1;
                        continue block15;
                    }
                    buffer.put((byte)32);
                    request.getProtocol().appendTo(buffer);
                    buffer.put((byte)13).put((byte)10);
                    headers = request.getRequestHeaders();
                    this.nameIterator = headers.getHeaderNames().iterator();
                    if (!this.nameIterator.hasNext()) {
                        HttpRequestConduit.log.trace("No request headers");
                        buffer.put((byte)13).put((byte)10);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            res = ((StreamSinkConduit)this.next).write(buffer);
                            if (res != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 11;
                        }
                        this.pooledBuffer.close();
                        this.pooledBuffer = null;
                        HttpRequestConduit.log.trace("Body");
                        return 0;
                    }
                    this.headerName = this.nameIterator.next();
                    this.charIndex = 0;
                }
                case 3: {
                    HttpRequestConduit.log.tracef("Processing header '%s'", (Object)this.headerName);
                    length = this.headerName.length();
                    while (this.charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put(this.headerName.byteAt(this.charIndex++));
                            continue;
                        }
                        HttpRequestConduit.log.trace("Buffer flush");
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 3;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                }
                case 4: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 4;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)58);
                }
                case 5: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 5;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)32);
                    if (this.valueIterator == null) {
                        this.valueIterator = request.getRequestHeaders().get(this.headerName).iterator();
                    }
                    if (!HttpRequestConduit.$assertionsDisabled && !this.valueIterator.hasNext()) {
                        throw new AssertionError();
                    }
                    this.string = this.valueIterator.next();
                    this.charIndex = 0;
                }
                case 6: {
                    HttpRequestConduit.log.tracef("Processing header value '%s'", (Object)this.string);
                    length = this.string.length();
                    while (this.charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put((byte)this.string.charAt(this.charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 6;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    this.charIndex = 0;
                    if (!this.valueIterator.hasNext()) {
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 7;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 8;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)10);
                        if (this.nameIterator.hasNext()) {
                            this.headerName = this.nameIterator.next();
                            this.valueIterator = null;
                            state = 3;
                            continue block15;
                        }
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 9;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 10;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)10);
                        this.nameIterator = null;
                        this.valueIterator = null;
                        this.string = null;
                        buffer.flip();
                        if (userData == null) {
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 11;
                            } while (buffer.hasRemaining());
                        } else {
                            b = new ByteBuffer[]{buffer, userData};
                            do {
                                if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 11;
                            } while (buffer.hasRemaining());
                        }
                        this.pooledBuffer.close();
                        this.pooledBuffer = null;
                        HttpRequestConduit.log.trace("Body");
                        return 0;
                    }
                }
                case 7: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 7;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)13);
                }
                case 8: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 8;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)10);
                    if (this.valueIterator != null && this.valueIterator.hasNext()) {
                        state = 3;
                        continue block15;
                    }
                    if (this.nameIterator.hasNext()) {
                        this.headerName = this.nameIterator.next();
                        this.valueIterator = null;
                        state = 3;
                        continue block15;
                    }
                }
                case 9: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 9;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)13);
                }
                case 10: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 10;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)10);
                    this.nameIterator = null;
                    this.valueIterator = null;
                    this.string = null;
                    buffer.flip();
                    if (userData != null) ** GOTO lbl294
                    do {
                        if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                        HttpRequestConduit.log.trace("Continuation");
                        return 11;
                    } while (buffer.hasRemaining());
                    ** GOTO lbl300
lbl294:
                    // 1 sources

                    b = new ByteBuffer[]{buffer, userData};
                    do {
                        if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                        HttpRequestConduit.log.trace("Continuation");
                        return 11;
                    } while (buffer.hasRemaining());
                }
lbl300:
                // 3 sources

                case 11: {
                    this.pooledBuffer.close();
                    this.pooledBuffer = null;
                    return 0;
                }
                case 1: {
                    for (i = this.charIndex; i < this.string.length(); ++i) {
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                this.charIndex = i;
                                this.state = 1;
                                return 1;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)this.string.charAt(i));
                    }
                    headers = request.getRequestHeaders();
                    this.nameIterator = headers.getHeaderNames().iterator();
                    state = 3;
                    if (!this.nameIterator.hasNext()) {
                        HttpRequestConduit.log.trace("No request headers");
                        buffer.put((byte)13).put((byte)10);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            res = ((StreamSinkConduit)this.next).write(buffer);
                            if (res != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 11;
                        }
                        this.pooledBuffer.close();
                        this.pooledBuffer = null;
                        HttpRequestConduit.log.trace("Body");
                        return 0;
                    }
                    this.headerName = this.nameIterator.next();
                    this.charIndex = 0;
                    continue block15;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int oldState;
        log.trace("write");
        do {
            if (!Bits.anyAreSet(oldState = this.state, 32)) continue;
            return 0;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | 0x20));
        int state = oldState & 0xF;
        int alreadyWritten = 0;
        int originalRemaining = -1;
        try {
            if (state != 0) {
                originalRemaining = src.remaining();
                if ((state = this.processWrite(state, src)) != 0) {
                    int n = 0;
                    return n;
                }
                alreadyWritten = originalRemaining - src.remaining();
                if (Bits.allAreSet(oldState, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            if (alreadyWritten != originalRemaining) {
                int n = ((StreamSinkConduit)this.next).write(src) + alreadyWritten;
                return n;
            }
            int n = alreadyWritten;
            return n;
        }
        catch (IOException | Error | RuntimeException e) {
            this.state |= 0x10;
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
            }
            throw e;
        }
        finally {
            this.state = oldState & 0xFFFFFFF0 | state;
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int oldVal;
        log.trace("write");
        if (length == 0) {
            return 0L;
        }
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 32)) continue;
            return 0L;
        } while (!stateUpdater.compareAndSet(this, oldVal, oldVal | 0x20));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = length == 1 ? (long)((StreamSinkConduit)this.next).write(srcs[offset]) : ((StreamSinkConduit)this.next).write(srcs, offset, length);
            return l;
        }
        catch (IOException | Error | RuntimeException e) {
            this.state |= 0x10;
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
            }
            throw e;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        int oldVal;
        log.trace("transfer");
        if (count == 0L) {
            return 0L;
        }
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 32)) continue;
            return 0L;
        } while (!stateUpdater.compareAndSet(this, oldVal, oldVal | 0x20));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = ((StreamSinkConduit)this.next).transferFrom(src, position, count);
            return l;
        }
        catch (IOException | Error | RuntimeException e) {
            this.state |= 0x10;
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
            }
            throw e;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        int oldVal;
        log.trace("transfer");
        if (count == 0L) {
            throughBuffer.clear().limit(0);
            return 0L;
        }
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 32)) continue;
            return 0L;
        } while (!stateUpdater.compareAndSet(this, oldVal, oldVal | 0x20));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = ((StreamSinkConduit)this.next).transferFrom(source2, count, throughBuffer);
            return l;
        }
        catch (IOException | Error | RuntimeException e) {
            this.state |= 0x10;
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
            }
            throw e;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public boolean flush() throws IOException {
        int oldVal;
        log.trace("flush");
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 32)) continue;
            return false;
        } while (!stateUpdater.compareAndSet(this, oldVal, oldVal | 0x20));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    log.trace("Flush false because headers aren't written yet");
                    boolean bl = false;
                    return bl;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                }
            }
            log.trace("Delegating flush");
            boolean bl = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        catch (IOException | Error | RuntimeException e) {
            this.state |= 0x10;
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
            }
            throw e;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        log.trace("shutdown");
        int oldVal = this.state;
        if (Bits.allAreClear(oldVal, 15)) {
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        this.state = oldVal | 0x10;
    }

    @Override
    public void truncateWrites() throws IOException {
        log.trace("close");
        int oldVal = this.state;
        if (Bits.allAreClear(oldVal, 15)) {
            try {
                ((StreamSinkConduit)this.next).truncateWrites();
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.close();
                    this.pooledBuffer = null;
                }
            }
            return;
        }
        this.state = oldVal & 0xFFFFFFF0 | 0x10;
        throw new TruncatedResponseException();
    }

    @Override
    public XnioWorker getWorker() {
        return ((StreamSinkConduit)this.next).getWorker();
    }

    public void freeBuffers() {
        if (this.pooledBuffer != null) {
            this.pooledBuffer.close();
            this.pooledBuffer = null;
            this.state = this.state & 0xFFFFFFF0 | 0x10;
        }
    }
}

