/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.traceability;

import com.networknt.config.Config;
import java.util.Map;

public class TraceabilityConfig {
    public static final String CONFIG_NAME = "traceability";
    private static final String ENABLED = "enabled";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    boolean enabled;

    private TraceabilityConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private TraceabilityConfig() {
        this(CONFIG_NAME);
    }

    public static TraceabilityConfig load(String configName) {
        return new TraceabilityConfig(configName);
    }

    public static TraceabilityConfig load() {
        return new TraceabilityConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        Object object;
        if (this.getMappedConfig() != null && (object = this.getMappedConfig().get(ENABLED)) != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
    }
}

