/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfig {
    public static final String CONFIG_NAME = "security";
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String ENABLE_VERIFY_JWT = "enableVerifyJwt";
    private static final String ENABLE_VERIFY_SWT = "enableVerifySwt";
    private static final String SWT_CLIENT_ID_HEADER = "swtClientIdHeader";
    private static final String SWT_CLIENT_SECRET_HEADER = "swtClientSecretHeader";
    private static final String ENABLE_EXTRACT_SCOPE_TOKEN = "enableExtractScopeToken";
    private static final String ENABLE_VERIFY_SCOPE = "enableVerifyScope";
    private static final String SKIP_VERIFY_SCOPE_WITHOUT_SPEC = "skipVerifyScopeWithoutSpec";
    private static final String ENABLE_MOCK_JWT = "enableMockJwt";
    private static final String JWT = "jwt";
    private static final String CERTIFICATE = "certificate";
    private static final String CLOCK_SKEW_IN_SECONDS = "clockSkewInSeconds";
    private static final String KEY_RESOLVER = "keyResolver";
    private static final String LOG_JWT_TOKEN = "logJwtToken";
    private static final String LOG_CLIENT_USER_SCOPE = "logClientUserScope";
    private static final String ENABLE_JWT_CACHE = "enableJwtCache";
    private static final String JWT_CACHE_FULL_SIZE = "jwtCacheFullSize";
    private static final String BOOTSTRAP_FROM_KEY_SERVICE = "bootstrapFromKeyService";
    private static final String IGNORE_JWT_EXPIRY = "ignoreJwtExpiry";
    private static final String PROVIDER_ID = "providerId";
    private static final String ENABLE_H2C = "enableH2c";
    private static final String ENABLE_RELAXED_KEY_CONSTRAINTS = "enableRelaxedKeyValidation";
    private static final String SKIP_PATH_PREFIXES = "skipPathPrefixes";
    private static final String PASS_THROUGH_CLAIMS = "passThroughClaims";
    private Map<String, Object> mappedConfig;
    private Map<String, Object> certificate;
    private Config config = Config.getInstance();
    private boolean enableVerifyJwt;
    private boolean enableVerifySwt;
    private String swtClientIdHeader;
    private String swtClientSecretHeader;
    private boolean enableExtractScopeToken;
    private boolean enableVerifyScope;
    private boolean skipVerifyScopeWithoutSpec;
    private boolean enableMockJwt;
    private int clockSkewInSeconds;
    private String keyResolver;
    private boolean logJwtToken;
    private boolean logClientUserScope;
    private boolean enableJwtCache;
    private int jwtCacheFullSize;
    private boolean bootstrapFromKeyService;
    private boolean ignoreJwtExpiry;
    private String providerId;
    private boolean enableH2c;
    private boolean enableRelaxedKeyValidation;
    private List<String> skipPathPrefixes;
    private Map<String, String> passThroughClaims;

    private SecurityConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setCertificate();
        this.setConfigData();
        this.setSkipPathPrefixes();
        this.setPassThroughClaims();
    }

    public static SecurityConfig load(String configName) {
        return new SecurityConfig(configName);
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setCertificate();
        this.setConfigData();
        this.setSkipPathPrefixes();
        this.setPassThroughClaims();
    }

    public Map<String, Object> getCertificate() {
        return this.certificate;
    }

    public boolean isEnableVerifyJwt() {
        return this.enableVerifyJwt;
    }

    public boolean isEnableVerifySwt() {
        return this.enableVerifySwt;
    }

    public String getSwtClientIdHeader() {
        return this.swtClientIdHeader;
    }

    public String getSwtClientSecretHeader() {
        return this.swtClientSecretHeader;
    }

    public boolean isEnableH2c() {
        return this.enableH2c;
    }

    public boolean isEnableRelaxedKeyValidation() {
        return this.enableRelaxedKeyValidation;
    }

    public boolean isEnableExtractScopeToken() {
        return this.enableExtractScopeToken;
    }

    public boolean isEnableVerifyScope() {
        return this.enableVerifyScope;
    }

    public boolean isSkipVerifyScopeWithoutSpec() {
        return this.skipVerifyScopeWithoutSpec;
    }

    public boolean isIgnoreJwtExpiry() {
        return this.ignoreJwtExpiry;
    }

    public boolean isEnableMockJwt() {
        return this.enableMockJwt;
    }

    public int getClockSkewInSeconds() {
        return this.clockSkewInSeconds;
    }

    public String getKeyResolver() {
        return this.keyResolver;
    }

    public boolean isLogJwtToken() {
        return this.logJwtToken;
    }

    public boolean isLogClientUserScope() {
        return this.logClientUserScope;
    }

    public boolean isEnableJwtCache() {
        return this.enableJwtCache;
    }

    public int getJwtCacheFullSize() {
        return this.jwtCacheFullSize;
    }

    public boolean isBootstrapFromKeyService() {
        return this.bootstrapFromKeyService;
    }

    public List<String> getSkipPathPrefixes() {
        return this.skipPathPrefixes;
    }

    public Map<String, String> getPassThroughClaims() {
        return this.passThroughClaims;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public String getProviderId() {
        return this.providerId;
    }

    Config getConfig() {
        return this.config;
    }

    private void setCertificate() {
        if (this.getMappedConfig() != null) {
            Map jwtMap = (Map)this.getMappedConfig().get(JWT);
            Object obj = jwtMap.get(CERTIFICATE);
            if (obj instanceof String) {
                String s2 = (String)obj;
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (String keyValue : s2.split(" *& *")) {
                    String[] pairs = keyValue.split(" *= *", 2);
                    map.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
                }
                this.certificate = map;
            } else {
                this.certificate = obj instanceof Map ? (Map<Object, Object>)obj : new HashMap<String, Object>();
            }
        }
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Map jwtMap;
            Object object = this.getMappedConfig().get(ENABLE_VERIFY_JWT);
            if (object != null) {
                this.enableVerifyJwt = Config.loadBooleanValue(ENABLE_VERIFY_JWT, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_VERIFY_SWT)) != null) {
                this.enableVerifySwt = Config.loadBooleanValue(ENABLE_VERIFY_SWT, object);
            }
            if ((object = this.getMappedConfig().get(SWT_CLIENT_ID_HEADER)) != null) {
                this.swtClientIdHeader = (String)object;
            }
            if ((object = this.getMappedConfig().get(SWT_CLIENT_SECRET_HEADER)) != null) {
                this.swtClientSecretHeader = (String)object;
            }
            if ((object = this.getMappedConfig().get(ENABLE_H2C)) != null) {
                this.enableH2c = Config.loadBooleanValue(ENABLE_H2C, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_RELAXED_KEY_CONSTRAINTS)) != null) {
                this.enableRelaxedKeyValidation = Config.loadBooleanValue(ENABLE_RELAXED_KEY_CONSTRAINTS, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_EXTRACT_SCOPE_TOKEN)) != null) {
                this.enableExtractScopeToken = Config.loadBooleanValue(ENABLE_EXTRACT_SCOPE_TOKEN, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_VERIFY_SCOPE)) != null) {
                this.enableVerifyScope = Config.loadBooleanValue(ENABLE_VERIFY_SCOPE, object);
            }
            if ((object = this.getMappedConfig().get(SKIP_VERIFY_SCOPE_WITHOUT_SPEC)) != null) {
                this.skipVerifyScopeWithoutSpec = Config.loadBooleanValue(SKIP_VERIFY_SCOPE_WITHOUT_SPEC, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_MOCK_JWT)) != null) {
                this.enableMockJwt = Config.loadBooleanValue(ENABLE_MOCK_JWT, object);
            }
            if ((object = this.getMappedConfig().get(LOG_JWT_TOKEN)) != null) {
                this.logJwtToken = Config.loadBooleanValue(LOG_JWT_TOKEN, object);
            }
            if ((object = this.getMappedConfig().get(LOG_CLIENT_USER_SCOPE)) != null) {
                this.logClientUserScope = Config.loadBooleanValue(LOG_CLIENT_USER_SCOPE, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_JWT_CACHE)) != null) {
                this.enableJwtCache = Config.loadBooleanValue(ENABLE_JWT_CACHE, object);
            }
            if ((object = this.getMappedConfig().get(JWT_CACHE_FULL_SIZE)) != null) {
                this.jwtCacheFullSize = Config.loadIntegerValue(JWT_CACHE_FULL_SIZE, object);
            }
            if ((object = this.getMappedConfig().get(BOOTSTRAP_FROM_KEY_SERVICE)) != null) {
                this.bootstrapFromKeyService = Config.loadBooleanValue(BOOTSTRAP_FROM_KEY_SERVICE, object);
            }
            if ((object = this.getMappedConfig().get(IGNORE_JWT_EXPIRY)) != null) {
                this.ignoreJwtExpiry = Config.loadBooleanValue(IGNORE_JWT_EXPIRY, object);
            }
            if ((object = this.getMappedConfig().get(PROVIDER_ID)) != null) {
                this.providerId = (String)object;
            }
            if ((jwtMap = (Map)this.getMappedConfig().get(JWT)) != null) {
                object = jwtMap.get(CLOCK_SKEW_IN_SECONDS);
                if (object != null) {
                    this.clockSkewInSeconds = Config.loadIntegerValue(CLOCK_SKEW_IN_SECONDS, object);
                }
                this.keyResolver = (String)jwtMap.get(KEY_RESOLVER);
            }
        }
    }

    private void setSkipPathPrefixes() {
        if (this.mappedConfig != null && this.mappedConfig.get(SKIP_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(SKIP_PATH_PREFIXES);
            this.skipPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.skipPathPrefixes = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the skipPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.skipPathPrefixes = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.skipPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("skipPathPrefixes must be a string or a list of strings.");
            }
        }
    }

    private void setPassThroughClaims() {
        if (this.mappedConfig != null && this.mappedConfig.get(PASS_THROUGH_CLAIMS) != null) {
            Object obj = this.mappedConfig.get(PASS_THROUGH_CLAIMS);
            if (obj instanceof String) {
                String s2 = (String)obj;
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("{")) {
                    try {
                        this.passThroughClaims = Config.getInstance().getMapper().readValue(s2, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("IOException:", e);
                    }
                } else {
                    this.passThroughClaims = new HashMap<String, String>();
                    for (String keyValue : s2.split(" *& *")) {
                        String[] pairs = keyValue.split(" *= *", 2);
                        this.passThroughClaims.put(pairs[0], pairs[1]);
                    }
                }
            } else if (obj instanceof Map) {
                this.passThroughClaims = (Map)obj;
            } else {
                logger.error("passThroughClaims is the wrong type. Only JSON map or YAML map is supported.");
            }
        }
    }
}

