/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.apikey.ApiKeyHandler;
import com.networknt.basicauth.BasicAuthHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.openapi.JwtVerifyHandler;
import com.networknt.openapi.SwtVerifyHandler;
import com.networknt.openapi.UnifiedPathPrefixAuth;
import com.networknt.openapi.UnifiedSecurityConfig;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedSecurityHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(UnifiedSecurityHandler.class);
    static final String BEARER_PREFIX = "BEARER";
    static final String BASIC_PREFIX = "BASIC";
    static final String API_KEY = "apikey";
    static final String JWT = "jwt";
    static final String SWT = "swt";
    static final String MISSING_AUTH_TOKEN = "ERR10002";
    static final String INVALID_AUTHORIZATION_HEADER = "ERR12003";
    static final String HANDLER_NOT_FOUND = "ERR11200";
    static final String MISSING_PATH_PREFIX_AUTH = "ERR10078";
    static UnifiedSecurityConfig config;
    private volatile HttpHandler next;

    public UnifiedSecurityHandler() {
        logger.info("UnifiedSecurityHandler starts");
        config = UnifiedSecurityConfig.load();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("UnifiedSecurityHandler.handleRequest starts.");
        }
        String reqPath = exchange.getRequestPath();
        if (config.getAnonymousPrefixes() != null) {
            if (config.getAnonymousPrefixes().stream().anyMatch(reqPath::startsWith)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skip request path base on anonymousPrefixes for " + reqPath);
                }
                Handler.next(exchange, this.next);
                return;
            }
        }
        if (config.getPathPrefixAuths() != null) {
            boolean found = false;
            for (UnifiedPathPrefixAuth pathPrefixAuth : config.getPathPrefixAuths()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Check with requestPath = " + reqPath + " prefix = " + pathPrefixAuth.getPathPrefix());
                }
                if (!reqPath.startsWith(pathPrefixAuth.getPathPrefix())) continue;
                found = true;
                if (logger.isTraceEnabled()) {
                    logger.trace("Found with requestPath = " + reqPath + " prefix = " + pathPrefixAuth.getPathPrefix());
                }
                if (pathPrefixAuth.isBasic() || pathPrefixAuth.isJwt() || pathPrefixAuth.isSwt()) {
                    String authorization = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
                    if (authorization == null) {
                        logger.error("Basic or JWT or SWT is enabled and authorization header is missing.");
                        if (pathPrefixAuth.isBasic()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Basic is enabled and set WWW-Authenticate header to Basic realm=\"Default Realm\"");
                            }
                            exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, "Basic realm=\"Default Realm\"");
                        }
                        this.setExchangeStatus(exchange, MISSING_AUTH_TOKEN, new Object[0]);
                        if (logger.isDebugEnabled()) {
                            logger.debug("UnifiedSecurityHandler.handleRequest ends with an error.");
                        }
                        exchange.endExchange();
                        return;
                    }
                    if (authorization.trim().length() <= 5) {
                        logger.error("Invalid/Unsupported authorization header {}", (Object)authorization);
                        this.setExchangeStatus(exchange, INVALID_AUTHORIZATION_HEADER, authorization);
                        exchange.endExchange();
                        return;
                    }
                    if (BASIC_PREFIX.equalsIgnoreCase(authorization.substring(0, 5))) {
                        Map<String, HttpHandler> handlers = Handler.getHandlers();
                        BasicAuthHandler handler = (BasicAuthHandler)handlers.get(BASIC_PREFIX.toLowerCase());
                        if (handler == null) {
                            logger.error("Cannot find BasicAuthHandler with alias name basic.");
                            this.setExchangeStatus(exchange, HANDLER_NOT_FOUND, "com.networknt.basicauth.BasicAuthHandler@basic");
                            exchange.endExchange();
                            return;
                        }
                        if (handler.handleBasicAuth(exchange, reqPath, authorization)) break;
                        return;
                    }
                    if (BEARER_PREFIX.equalsIgnoreCase(authorization.substring(0, 6))) {
                        Map<String, HttpHandler> handlers = Handler.getHandlers();
                        if (pathPrefixAuth.isJwt() && pathPrefixAuth.isSwt()) {
                            boolean isJwt = StringUtils.isJwtToken(authorization);
                            if (logger.isTraceEnabled()) {
                                logger.trace("Both jwt and swt are true and check token is jwt = {}", (Object)isJwt);
                            }
                            if (isJwt) {
                                JwtVerifyHandler handler = (JwtVerifyHandler)handlers.get(JWT);
                                if (handler == null) {
                                    logger.error("Cannot find JwtVerifyHandler with alias name jwt.");
                                    this.setExchangeStatus(exchange, HANDLER_NOT_FOUND, "com.networknt.openapi.JwtVerifyHandler@jwt");
                                    exchange.endExchange();
                                    return;
                                }
                                if (handler.handleJwt(exchange, pathPrefixAuth.getPathPrefix(), reqPath, pathPrefixAuth.getJwkServiceIds())) break;
                                return;
                            }
                            SwtVerifyHandler handler = (SwtVerifyHandler)handlers.get(SWT);
                            if (handler == null) {
                                logger.error("Cannot find SwtVerifyHandler with alias name swt.");
                                this.setExchangeStatus(exchange, HANDLER_NOT_FOUND, "com.networknt.openapi.SwtVerifyHandler@swt");
                                exchange.endExchange();
                                return;
                            }
                            if (handler.handleSwt(exchange, reqPath, pathPrefixAuth.getSwtServiceIds())) break;
                            return;
                        }
                        if (pathPrefixAuth.isJwt()) {
                            JwtVerifyHandler handler = (JwtVerifyHandler)handlers.get(JWT);
                            if (handler == null) {
                                logger.error("Cannot find JwtVerifyHandler with alias name jwt.");
                                this.setExchangeStatus(exchange, HANDLER_NOT_FOUND, "com.networknt.openapi.JwtVerifyHandler@jwt");
                                exchange.endExchange();
                                return;
                            }
                            if (handler.handleJwt(exchange, pathPrefixAuth.getPathPrefix(), reqPath, pathPrefixAuth.getJwkServiceIds())) break;
                            return;
                        }
                        SwtVerifyHandler handler = (SwtVerifyHandler)handlers.get(SWT);
                        if (handler == null) {
                            logger.error("Cannot find SwtVerifyHandler with alias name swt.");
                            this.setExchangeStatus(exchange, HANDLER_NOT_FOUND, "com.networknt.openapi.SwtVerifyHandler@swt");
                            exchange.endExchange();
                            return;
                        }
                        if (handler.handleSwt(exchange, reqPath, pathPrefixAuth.getSwtServiceIds())) break;
                        return;
                    }
                    String s2 = authorization.length() > 10 ? authorization.substring(0, 10) : authorization;
                    logger.error("Invalid/Unsupported authorization header {}", (Object)s2);
                    this.setExchangeStatus(exchange, INVALID_AUTHORIZATION_HEADER, s2);
                    exchange.endExchange();
                    return;
                }
                if (!pathPrefixAuth.isApikey()) continue;
                Map<String, HttpHandler> handlers = Handler.getHandlers();
                ApiKeyHandler handler = (ApiKeyHandler)handlers.get(API_KEY);
                if (handler == null) {
                    logger.error("Cannot find ApiKeyHandler with alias name apikey.");
                    this.setExchangeStatus(exchange, HANDLER_NOT_FOUND, "com.networknt.apikey.ApiKeyHandler@apikey");
                    exchange.endExchange();
                    return;
                }
                if (handler.handleApiKey(exchange, reqPath)) break;
                return;
            }
            if (!found) {
                logger.error("Cannot find prefix entry in pathPrefixAuths for " + reqPath);
                this.setExchangeStatus(exchange, MISSING_PATH_PREFIX_AUTH, reqPath);
                exchange.endExchange();
                return;
            }
        } else {
            logger.error("Cannot find pathPrefixAuths definition for " + reqPath);
            this.setExchangeStatus(exchange, MISSING_PATH_PREFIX_AUTH, reqPath);
            exchange.endExchange();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("UnifiedSecurityHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("unified-security", UnifiedSecurityHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("unified-security"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("unified-security", UnifiedSecurityHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("unified-security"), null);
    }
}

