/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.cache.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class Client
implements IdentifiedDataSerializable,
Comparable {
    private String clientId = null;
    private String clientSecret = null;
    private ClientTypeEnum clientType = null;
    private ClientProfileEnum clientProfile = null;
    private String clientName = null;
    private String clientDesc = null;
    private String ownerId = null;
    private String host = null;
    private String scope = null;
    private String customClaim = null;
    private String redirectUri = null;
    private String authenticateClass = null;
    private String derefClientId = null;

    public int compareTo(Object o) {
        return this.getClientName().compareTo(((Client)o).getClientName());
    }

    public Client clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Client clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="clientSecret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Client clientType(ClientTypeEnum clientType) {
        this.clientType = clientType;
        return this;
    }

    @JsonProperty(value="clientType")
    public ClientTypeEnum getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientTypeEnum clientType) {
        this.clientType = clientType;
    }

    public Client clientProfile(ClientProfileEnum clientProfile) {
        this.clientProfile = clientProfile;
        return this;
    }

    @JsonProperty(value="clientProfile")
    public ClientProfileEnum getClientProfile() {
        return this.clientProfile;
    }

    public void setClientProfile(ClientProfileEnum clientProfile) {
        this.clientProfile = clientProfile;
    }

    public Client clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @JsonProperty(value="clientName")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Client clientDesc(String clientDesc) {
        this.clientDesc = clientDesc;
        return this;
    }

    @JsonProperty(value="clientDesc")
    public String getClientDesc() {
        return this.clientDesc;
    }

    public void setClientDesc(String clientDesc) {
        this.clientDesc = clientDesc;
    }

    public Client ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @JsonProperty(value="ownerId")
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Client host(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Client scope(String scope) {
        this.scope = scope;
        return this;
    }

    @JsonProperty(value="scope")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Client customClaim(String customClaim) {
        this.customClaim = customClaim;
        return this;
    }

    @JsonProperty(value="customClaim")
    public String getCustomClaim() {
        return this.customClaim;
    }

    public void setCustomClaim(String customClaim) {
        this.customClaim = customClaim;
    }

    public Client redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @JsonProperty(value="redirectUri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Client authenticateClass(String authenticateClass) {
        this.authenticateClass = authenticateClass;
        return this;
    }

    @JsonProperty(value="authenticateClass")
    public String getAuthenticateClass() {
        return this.authenticateClass;
    }

    public void setAuthenticateClass(String authenticateClass) {
        this.authenticateClass = authenticateClass;
    }

    public Client derefClientId(String derefClientId) {
        this.derefClientId = derefClientId;
        return this;
    }

    @JsonProperty(value="derefClientId")
    public String getDerefClientId() {
        return this.derefClientId;
    }

    public void setDerefClientId(String derefClientId) {
        this.derefClientId = derefClientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.clientId, client.clientId) && Objects.equals(this.clientSecret, client.clientSecret) && Objects.equals((Object)this.clientType, (Object)client.clientType) && Objects.equals((Object)this.clientProfile, (Object)client.clientProfile) && Objects.equals(this.clientName, client.clientName) && Objects.equals(this.clientDesc, client.clientDesc) && Objects.equals(this.ownerId, client.ownerId) && Objects.equals(this.host, client.host) && Objects.equals(this.scope, client.scope) && Objects.equals(this.customClaim, client.customClaim) && Objects.equals(this.redirectUri, client.redirectUri) && Objects.equals(this.derefClientId, client.derefClientId) && Objects.equals(this.authenticateClass, client.authenticateClass);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.clientSecret, this.clientType, this.clientProfile, this.clientName, this.clientDesc, this.ownerId, this.host, this.scope, this.customClaim, this.redirectUri, this.authenticateClass, this.derefClientId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Client {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    clientType: ").append(this.toIndentedString((Object)this.clientType)).append("\n");
        sb.append("    clientProfile: ").append(this.toIndentedString((Object)this.clientProfile)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    clientDesc: ").append(this.toIndentedString(this.clientDesc)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    customClaim: ").append(this.toIndentedString(this.customClaim)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    authenticateClass: ").append(this.toIndentedString(this.authenticateClass)).append("\n");
        sb.append("    derefClientId: ").append(this.toIndentedString(this.derefClientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.clientId = in.readUTF();
        this.clientSecret = in.readUTF();
        this.clientType = ClientTypeEnum.fromValue(in.readUTF());
        this.clientProfile = ClientProfileEnum.fromValue(in.readUTF());
        this.clientName = in.readUTF();
        this.clientDesc = in.readUTF();
        this.ownerId = in.readUTF();
        this.host = in.readUTF();
        this.scope = in.readUTF();
        this.customClaim = in.readUTF();
        this.redirectUri = in.readUTF();
        this.authenticateClass = in.readUTF();
        this.derefClientId = in.readUTF();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.clientId);
        out.writeUTF(this.clientSecret);
        out.writeUTF(this.clientType.toString());
        out.writeUTF(this.clientProfile.toString());
        out.writeUTF(this.clientName);
        out.writeUTF(this.clientDesc);
        out.writeUTF(this.ownerId);
        out.writeUTF(this.host);
        out.writeUTF(this.scope);
        out.writeUTF(this.customClaim);
        out.writeUTF(this.redirectUri);
        out.writeUTF(this.authenticateClass);
        out.writeUTF(this.derefClientId);
    }

    @Override
    @JsonIgnore
    public int getFactoryId() {
        return 2;
    }

    @Override
    @JsonIgnore
    public int getClassId() {
        return 2;
    }

    public static Client copyClient(Client c) {
        Client n = new Client();
        n.setClientId(c.getClientId());
        n.setClientSecret(c.getClientSecret());
        n.setClientType(c.getClientType());
        n.setClientProfile(c.getClientProfile());
        n.setClientName(c.getClientName());
        n.setClientDesc(c.getClientDesc());
        n.setOwnerId(c.getOwnerId());
        n.setHost(c.getHost());
        n.setScope(c.getScope());
        n.setCustomClaim(c.getCustomClaim());
        n.setRedirectUri(c.getRedirectUri());
        n.setAuthenticateClass(c.getAuthenticateClass());
        n.setDerefClientId(c.getDerefClientId());
        return n;
    }

    public static enum ClientProfileEnum {
        WEBSERVER("webserver"),
        BROWSER("browser"),
        MOBILE("mobile"),
        SERVICE("service"),
        BATCH("batch");

        private final String value;

        private ClientProfileEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClientProfileEnum fromValue(String text) {
            for (ClientProfileEnum b : ClientProfileEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ClientTypeEnum {
        CONFIDENTIAL("confidential"),
        PUBLIC("public"),
        TRUSTED("trusted"),
        EXTERNAL("external");

        private final String value;

        private ClientTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClientTypeEnum fromValue(String text) {
            for (ClientTypeEnum b : ClientTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

