/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.config.Config;
import java.util.Map;

public class MetricsConfig {
    public static final String CONFIG_NAME = "metrics";
    private static final String ENABLED = "enabled";
    private static final String ENABLED_JVM_MONITOR = "enableJVMMonitor";
    private static final String SERVER_PROTOCOL = "serverProtocol";
    private static final String SERVER_HOST = "serverHost";
    private static final String SERVER_PORT = "serverPort";
    private static final String SERVER_PATH = "serverPath";
    private static final String SERVER_NAME = "serverName";
    private static final String SERVER_USER = "serverUser";
    private static final String SERVER_PASS = "serverPass";
    private static final String REPORT_IN_MINUTES = "reportInMinutes";
    private static final String PRODUCT_NAME = "productName";
    private static final String SEND_SCOPE_CLIENT_ID = "sendScopeClientId";
    private static final String SEND_CALLER_ID = "sendCallerId";
    private static final String SEND_ISSUER = "sendIssuer";
    private static final String ISSUER_REGEX = "issuerRegex";
    boolean enabled;
    boolean enableJVMMonitor;
    String serverProtocol;
    String serverHost;
    int serverPort;
    String serverPath;
    String serverName;
    String serverUser;
    String serverPass;
    int reportInMinutes;
    String productName;
    boolean sendScopeClientId;
    boolean sendCallerId;
    boolean sendIssuer;
    String issuerRegex;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    private MetricsConfig() {
        this(CONFIG_NAME);
    }

    private MetricsConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    static MetricsConfig load() {
        return new MetricsConfig();
    }

    static MetricsConfig load(String configName) {
        return new MetricsConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableJVMMonitor() {
        return this.enableJVMMonitor;
    }

    public void setEnableJVMMonitor(boolean enableJVMMonitor) {
        this.enableJVMMonitor = enableJVMMonitor;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getReportInMinutes() {
        return this.reportInMinutes;
    }

    public void setReportInMinutes(int reportInMinutes) {
        this.reportInMinutes = reportInMinutes;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerUser() {
        return this.serverUser;
    }

    public void setServerUser(String serverUser) {
        this.serverUser = serverUser;
    }

    public String getServerPass() {
        return this.serverPass;
    }

    public void setServerPass(String serverPass) {
        this.serverPass = serverPass;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public boolean isSendScopeClientId() {
        return this.sendScopeClientId;
    }

    public void setSendScopeClientId(boolean sendScopeClientId) {
        this.sendScopeClientId = sendScopeClientId;
    }

    public boolean isSendCallerId() {
        return this.sendCallerId;
    }

    public void setSendCallerId(boolean sendCallerId) {
        this.sendCallerId = sendCallerId;
    }

    public boolean isSendIssuer() {
        return this.sendIssuer;
    }

    public void setSendIssuer(boolean sendIssuer) {
        this.sendIssuer = sendIssuer;
    }

    public String getIssuerRegex() {
        return this.issuerRegex;
    }

    public void setIssuerRegex(String issuerRegex) {
        this.issuerRegex = issuerRegex;
    }

    Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.getMappedConfig().get(ENABLED_JVM_MONITOR)) != null) {
            this.enableJVMMonitor = Config.loadBooleanValue(ENABLED_JVM_MONITOR, object);
        }
        if ((object = this.mappedConfig.get(SERVER_PROTOCOL)) != null) {
            this.setServerProtocol((String)object);
        }
        if ((object = this.mappedConfig.get(SERVER_HOST)) != null) {
            this.serverHost = (String)object;
        }
        if ((object = this.mappedConfig.get(SERVER_PORT)) != null) {
            this.serverPort = Config.loadIntegerValue(SERVER_PORT, object);
        }
        if ((object = this.getMappedConfig().get(SERVER_PATH)) != null) {
            this.serverPath = (String)object;
        }
        if ((object = this.getMappedConfig().get(SERVER_NAME)) != null) {
            this.serverName = (String)object;
        }
        if ((object = this.getMappedConfig().get(SERVER_USER)) != null) {
            this.serverUser = (String)object;
        }
        if ((object = this.getMappedConfig().get(SERVER_PASS)) != null) {
            this.serverPass = (String)object;
        }
        if ((object = this.getMappedConfig().get(REPORT_IN_MINUTES)) != null) {
            this.reportInMinutes = Config.loadIntegerValue(REPORT_IN_MINUTES, object);
        }
        if ((object = this.getMappedConfig().get(PRODUCT_NAME)) != null) {
            this.productName = (String)object;
        }
        if ((object = this.getMappedConfig().get(SEND_SCOPE_CLIENT_ID)) != null) {
            this.sendScopeClientId = Config.loadBooleanValue(SEND_SCOPE_CLIENT_ID, object);
        }
        if ((object = this.getMappedConfig().get(SEND_CALLER_ID)) != null) {
            this.sendCallerId = Config.loadBooleanValue(SEND_CALLER_ID, object);
        }
        if ((object = this.getMappedConfig().get(SEND_ISSUER)) != null) {
            this.sendIssuer = Config.loadBooleanValue(SEND_ISSUER, object);
        }
        if ((object = this.getMappedConfig().get(ISSUER_REGEX)) != null) {
            this.issuerRegex = (String)object;
        }
    }
}

