/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.AbstractDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.IRequestDumpable;
import com.networknt.mask.Mask;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParametersDumper
extends AbstractDumper
implements IRequestDumpable {
    private Map<String, Object> queryParametersMap = new LinkedHashMap<String, Object>();

    public QueryParametersDumper(DumpConfig config, HttpServerExchange exchange) {
        super(config, exchange);
    }

    @Override
    public void dumpRequest(Map<String, Object> result) {
        this.exchange.getQueryParameters().forEach((k, v) -> {
            if (this.config.getRequestFilteredQueryParameters().contains(k)) {
                String queryParameterValue = this.config.isMaskEnabled() ? Mask.maskRegex((String)v.getFirst(), "queryParameter", k) : (String)v.getFirst();
                this.queryParametersMap.put((String)k, queryParameterValue);
            }
        });
        this.putDumpInfoTo(result);
    }

    @Override
    protected void putDumpInfoTo(Map<String, Object> result) {
        if (this.queryParametersMap.size() > 0) {
            result.put("queryParameters", this.queryParametersMap);
        }
    }

    @Override
    public boolean isApplicableForRequest() {
        return this.config.isRequestQueryParametersEnabled();
    }
}

