/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.status.Status;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenRequest
extends TokenRequest {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    String refreshToken;

    public RefreshTokenRequest() {
        this.setGrantType("refresh_token");
        Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null) {
            this.setServerUrl((String)tokenConfig.get("server_url"));
            this.setProxyHost((String)tokenConfig.get("proxyHost"));
            int port = tokenConfig.get("proxyPort") == null ? 443 : (Integer)tokenConfig.get("proxyPort");
            this.setProxyPort(port);
            this.setServiceId((String)tokenConfig.get("serviceId"));
            Object object = tokenConfig.get("enableHttp2");
            this.setEnableHttp2(object != null && (Boolean)object != false);
            Map rtConfig = (Map)tokenConfig.get("refresh_token");
            if (rtConfig != null) {
                this.setClientId((String)rtConfig.get("client_id"));
                if (rtConfig.get("client_secret") != null) {
                    this.setClientSecret((String)rtConfig.get("client_secret"));
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, "refresh_token client_secret", "client.yml").toString());
                }
                this.setUri((String)rtConfig.get("uri"));
                this.setScope((List)rtConfig.get("scope"));
            }
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

