/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.networknt.body.BodyConfig;
import com.networknt.common.ContentType;
import com.networknt.handler.BuffersUtils;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.RequestInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBodyInterceptor
implements RequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestBodyInterceptor.class);
    public BodyConfig config;
    private volatile HttpHandler next;

    public RequestBodyInterceptor() {
        if (LOG.isInfoEnabled()) {
            LOG.info("RequestBodyInterceptor is loaded.");
        }
        this.config = BodyConfig.load();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("RequestBodyInterceptor.handleRequest starts.");
        }
        if (this.shouldAttachBody(exchange.getRequestHeaders())) {
            PooledByteBuffer[] existing = exchange.getAttachment(AttachmentConstants.BUFFERED_REQUEST_DATA_KEY);
            if (LOG.isTraceEnabled()) {
                LOG.trace("request body exists in exchange attachment = {}", (Object)(existing != null ? 1 : 0));
            }
            if (existing != null) {
                boolean attached;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Attach request body requirement is met and the byte buffer pool exists.");
                }
                String completeBody = BuffersUtils.toString(existing, StandardCharsets.UTF_8);
                String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                if (LOG.isTraceEnabled()) {
                    if (this.config.isLogFullRequestBody()) {
                        LOG.trace("contentType = " + contentType + " request body = " + completeBody);
                    } else {
                        LOG.trace("contentType = " + contentType + " request body = " + (completeBody.length() > 16384 ? completeBody.substring(0, 16384) : completeBody));
                    }
                }
                if (!(attached = this.handleBody(exchange, completeBody, contentType)) && LOG.isErrorEnabled()) {
                    LOG.error("Failed to attach the request body to the exchange!");
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("Request body was attached to exchange");
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Request body interceptor is skipped due to the request path is not in request-injection.appliedBodyInjectionPathPrefixes configuration");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RequestBodyInterceptor.handleRequest ends.");
        }
    }

    private boolean handleBody(HttpServerExchange ex, String body, String contentType) {
        if (this.isJsonData(contentType)) {
            return this.attachJsonBody(ex, body);
        }
        if (this.isXmlData(contentType)) {
            return this.attachXmlBody(ex, body);
        }
        if (this.isFormData(contentType)) {
            return this.attachFormDataBody(ex, body);
        }
        return false;
    }

    public boolean attachJsonBody(HttpServerExchange ex, String str) {
        if ((str = str.trim()).charAt(0) == '{') {
            this.cacheRequestBody(ex, str);
            return this.parseJsonMapObject(ex, AttachmentConstants.REQUEST_BODY, str);
        }
        if (str.charAt(0) == '[') {
            this.cacheRequestBody(ex, str);
            return this.parseJsonArrayObject(ex, AttachmentConstants.REQUEST_BODY, str);
        }
        this.setExchangeStatus(ex, "ERR10015", ContentType.APPLICATION_JSON.value());
        return false;
    }

    public boolean attachXmlBody(HttpServerExchange exchange, String s2) {
        this.cacheRequestBody(exchange, s2);
        return true;
    }

    public boolean attachFormDataBody(HttpServerExchange exchange, String s2) {
        this.cacheRequestBody(exchange, s2);
        return true;
    }

    private void cacheRequestBody(HttpServerExchange exchange, String s2) {
        if (this.config.isCacheRequestBody()) {
            exchange.putAttachment(AttachmentConstants.REQUEST_BODY_STRING, s2);
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("body", RequestBodyInterceptor.class.getName(), this.config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        this.config.reload();
        ModuleRegistry.registerModule("body", RequestBodyInterceptor.class.getName(), this.config.getMappedConfig(), null);
        if (LOG.isInfoEnabled()) {
            LOG.info("RequestBodyInterceptor is reloaded.");
        }
    }

    @Override
    public boolean isRequiredContent() {
        return true;
    }
}

