/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.balance;

import com.networknt.balance.LoadBalance;
import com.networknt.registry.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLoadBalance
implements LoadBalance {
    static Logger logger = LoggerFactory.getLogger(RoundRobinLoadBalance.class);
    Map<String, AtomicInteger> serviceIdx = new ConcurrentHashMap<String, AtomicInteger>();

    public RoundRobinLoadBalance() {
        if (logger.isInfoEnabled()) {
            logger.info("A RoundRobinLoadBalance instance is started");
        }
    }

    @Override
    public URL select(List<URL> urls2, String serviceId, String tag, String requestKey) {
        URL url = null;
        if (urls2.size() > 1) {
            String key = tag == null ? serviceId : serviceId + "|" + tag;
            url = this.doSelect(urls2, key);
        } else if (urls2.size() == 1) {
            url = urls2.get(0);
        }
        return url;
    }

    protected URL doSelect(List<URL> urls2, String key) {
        int index = this.getNextPositive(key);
        for (int i = 0; i < urls2.size(); ++i) {
            URL url = urls2.get((i + index) % urls2.size());
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private int getNextPositive(String key) {
        AtomicInteger idx = this.serviceIdx.get(key);
        if (idx == null) {
            idx = new AtomicInteger((int)(Math.random() * 10.0));
            this.serviceIdx.put(key, idx);
        }
        return this.getPositive(idx.incrementAndGet());
    }
}

