/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.merge;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.merge.SplitBrainDataSerializerHook;
import com.hazelcast.spi.merge.MergingValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public abstract class AbstractCollectionMergingValueImpl<V, T extends AbstractCollectionMergingValueImpl<V, T>>
implements MergingValue<Collection<V>>,
SerializationServiceAware,
IdentifiedDataSerializable {
    private Collection<Object> value;
    private transient SerializationService serializationService;

    public AbstractCollectionMergingValueImpl() {
    }

    public AbstractCollectionMergingValueImpl(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public Collection<Object> getRawValue() {
        return this.value;
    }

    @Override
    public Collection<V> getValue() {
        ArrayList deserializedValues = new ArrayList(this.value.size());
        for (Object aValue : this.value) {
            deserializedValues.add(this.serializationService.toObject(aValue));
        }
        return deserializedValues;
    }

    public T setValue(Collection<Object> value) {
        this.value = value;
        return (T)this;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.value.size());
        for (Object aValue : this.value) {
            IOUtil.writeObject(out, aValue);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(IOUtil.readObject(in));
        }
        this.value = list;
    }

    @Override
    public int getFactoryId() {
        return SplitBrainDataSerializerHook.F_ID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCollectionMergingValueImpl)) {
            return false;
        }
        AbstractCollectionMergingValueImpl that = (AbstractCollectionMergingValueImpl)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "MergingValue{value=" + this.value + '}';
    }
}

