/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Map;
import java.util.concurrent.Future;

public class NodeInvokerWrapper
implements InvokerWrapper {
    private final OperationService operationService;

    NodeInvokerWrapper(OperationService operationService) {
        this.operationService = operationService;
    }

    @Override
    public Future invokeOnPartitionOwner(Object operation, int partitionId) {
        Preconditions.checkNotNull(operation, "operation cannot be null");
        Preconditions.checkNotNegative(partitionId, "partitionId");
        Operation op = (Operation)operation;
        return this.operationService.invokeOnPartition("hz:impl:mapService", op, partitionId);
    }

    @Override
    public Map<Integer, Object> invokeOnAllPartitions(Object request, boolean urgent) throws Exception {
        Preconditions.checkInstanceOf(OperationFactory.class, request, "request");
        OperationFactory factory2 = (OperationFactory)request;
        return this.operationService.invokeOnAllPartitions("hz:impl:mapService", factory2);
    }

    @Override
    public Future invokeOnTarget(Object operation, Member member) {
        Preconditions.checkNotNull(operation, "operation cannot be null");
        Preconditions.checkNotNull(member, "address cannot be null");
        Operation op = (Operation)operation;
        return this.operationService.invokeOnTarget("hz:impl:mapService", op, member.getAddress());
    }

    @Override
    public Object invoke(Object operation, boolean urgent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeOperation(Operation operation) {
        Preconditions.checkNotNull(operation, "operation cannot be null");
        this.operationService.execute(operation);
    }
}

