/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.function.RunnableEx;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Observer<T> {
    @Nonnull
    public static <T> Observer<T> of(final @Nonnull ConsumerEx<? super T> onNext, final @Nonnull ConsumerEx<? super Throwable> onError, final @Nonnull RunnableEx onComplete) {
        return new Observer<T>(){

            @Override
            public void onNext(@Nonnull T t2) {
                onNext.accept(t2);
            }

            @Override
            public void onError(@Nonnull Throwable throwable) {
                onError.accept(throwable);
            }

            @Override
            public void onComplete() {
                onComplete.run();
            }
        };
    }

    @Nonnull
    public static <T> Observer<T> of(@Nonnull ConsumerEx<? super T> onNext) {
        return onNext::accept;
    }

    public void onNext(@Nonnull T var1);

    default public void onError(@Nonnull Throwable throwable) {
        throwable.printStackTrace();
    }

    default public void onComplete() {
    }
}

