/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.logging;

import com.hazelcast.internal.tpcengine.logging.TpcLogger;
import com.hazelcast.internal.tpcengine.logging.TpcLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JulLoggerFactory
implements TpcLoggerFactory {
    private final ConcurrentMap<String, TpcLogger> mapLoggers = new ConcurrentHashMap<String, TpcLogger>(100);

    @Override
    public TpcLogger getLogger(String name) {
        TpcLogger logger2 = (TpcLogger)this.mapLoggers.get(name);
        if (logger2 != null) {
            return logger2;
        }
        logger2 = new JulLogger(Logger.getLogger(name));
        TpcLogger found = this.mapLoggers.putIfAbsent(name, logger2);
        return found == null ? logger2 : found;
    }

    private static final class JulLogger
    implements TpcLogger {
        private final Logger logger;

        private JulLogger(Logger logger2) {
            this.logger = logger2;
        }

        @Override
        public void finest(Throwable thrown) {
            this.log(Level.FINEST, null, thrown.getCause());
        }

        @Override
        public boolean isFinestEnabled() {
            return this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public void fine(Throwable thrown) {
            this.logger.log(Level.FINE, null, thrown);
        }

        @Override
        public void fine(String message, Throwable thrown) {
            this.logger.log(Level.FINE, message, thrown);
        }

        @Override
        public void info(Throwable thrown) {
            this.logger.log(Level.INFO, null, thrown);
        }

        @Override
        public void info(String message, Throwable thrown) {
            this.logger.log(Level.INFO, message, thrown);
        }

        @Override
        public void warning(String message, Throwable thrown) {
            this.logger.log(Level.WARNING, message, thrown);
        }

        @Override
        public boolean isWarningEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public void severe(String message) {
            this.logger.severe(message);
        }

        @Override
        public boolean isSevereEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public void log(Level level, String message) {
            this.logger.log(level, message);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            this.logger.log(level, message, thrown);
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }

        @Override
        public boolean isFineEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public void finest(String msg) {
            this.logger.finest(msg);
        }

        @Override
        public void finest(String msg, Throwable cause) {
            this.logger.log(Level.FINEST, cause.toString(), cause);
        }

        @Override
        public void fine(String msg) {
            this.logger.fine(msg);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void warning(Throwable cause) {
            this.logger.log(Level.WARNING, cause.toString(), cause);
        }

        @Override
        public void warning(String msg) {
            this.logger.warning(msg);
        }

        @Override
        public void severe(Throwable cause) {
            this.logger.log(Level.SEVERE, cause.toString(), cause);
        }

        @Override
        public void severe(String msg, Throwable cause) {
            this.logger.log(Level.SEVERE, cause.toString(), cause);
        }
    }
}

