/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.membergroup;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.membergroup.BackupSafeMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.DefaultMemberGroup;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodeAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        Map<String, MemberGroup> groups2 = MapUtil.createHashMap(allMembers.size());
        for (Member member : allMembers) {
            String nodeInfo = member.getAttribute("hazelcast.partition.group.node");
            if (nodeInfo == null) {
                throw new IllegalArgumentException("Not enough metadata information is provided. Node name information must be provided with NODE_AWARE partition group.");
            }
            MemberGroup group = (MemberGroup)groups2.get(nodeInfo);
            if (group == null) {
                group = new DefaultMemberGroup();
                groups2.put(nodeInfo, group);
            }
            group.addMember(member);
        }
        return new HashSet<MemberGroup>(groups2.values());
    }
}

