/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.impl.MigrationQueue;
import com.hazelcast.internal.partition.impl.MigrationRunnable;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.TimeUnit;

class MigrationThread
extends Thread
implements Runnable {
    private static final long DEFAULT_MIGRATION_SLEEP_INTERVAL = 250L;
    private final MigrationManager migrationManager;
    private final MigrationQueue queue;
    private final ILogger logger;
    private final long partitionMigrationInterval;
    private final long sleepTime;
    private volatile MigrationRunnable activeTask;
    private volatile boolean running = true;

    MigrationThread(MigrationManager migrationManager, String hzName, ILogger logger2, MigrationQueue queue) {
        super(ThreadUtil.createThreadName(hzName, "migration"));
        this.migrationManager = migrationManager;
        this.queue = queue;
        this.partitionMigrationInterval = migrationManager.partitionMigrationInterval;
        this.sleepTime = Math.max(250L, this.partitionMigrationInterval);
        this.logger = logger2;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                this.doRun();
                if (this.migrationManager.areMigrationTasksAllowed()) continue;
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException e) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("MigrationThread is interrupted: " + e.getMessage());
            }
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryErrorDispatcher.onOutOfMemory(e);
        }
        finally {
            this.queue.clear();
        }
    }

    private void doRun() throws InterruptedException {
        MigrationRunnable runnable2;
        while (this.migrationManager.areMigrationTasksAllowed() && (runnable2 = this.queue.poll(1, TimeUnit.SECONDS)) != null) {
            this.processTask(runnable2);
        }
    }

    private void processTask(MigrationRunnable runnable2) {
        try {
            if (!this.running) {
                return;
            }
            this.activeTask = runnable2;
            runnable2.run();
        }
        catch (Throwable t2) {
            this.logger.warning(t2);
        }
        finally {
            this.queue.afterTaskCompletion(runnable2);
            this.activeTask = null;
        }
    }

    void abortMigrationTask() {
        MigrationRunnable task = this.activeTask;
        if (task instanceof MigrationManager.MigrationPlanTask) {
            ((MigrationManager.MigrationPlanTask)task).abort();
        }
    }

    void stopNow() {
        assert (MigrationThread.currentThread() != this) : "stopNow must not be called on the migration thread";
        this.running = false;
        this.queue.clear();
        this.interrupt();
        boolean currentThreadInterrupted = false;
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                currentThreadInterrupted = true;
                continue;
            }
            break;
        }
        if (currentThreadInterrupted) {
            MigrationThread.currentThread().interrupt();
        }
    }
}

