/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.durableexecutor.impl;

import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.durableexecutor.impl.DurableExecutorContainer;
import com.hazelcast.durableexecutor.impl.TaskRingBuffer;
import com.hazelcast.durableexecutor.impl.operations.ReplicationOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DurableExecutorPartitionContainer {
    private final int partitionId;
    private final NodeEngineImpl nodeEngine;
    private final ConcurrentMap<String, DurableExecutorContainer> executorContainerMap = new ConcurrentHashMap<String, DurableExecutorContainer>();

    public DurableExecutorPartitionContainer(NodeEngineImpl nodeEngine, int partitionId) {
        this.nodeEngine = nodeEngine;
        this.partitionId = partitionId;
    }

    public DurableExecutorContainer getOrCreateContainer(String name) {
        DurableExecutorContainer executorContainer = (DurableExecutorContainer)this.executorContainerMap.get(name);
        if (executorContainer == null) {
            executorContainer = this.createExecutorContainer(name);
            this.executorContainerMap.put(name, executorContainer);
        }
        return executorContainer;
    }

    public void createExecutorContainer(String name, TaskRingBuffer ringBuffer) {
        DurableExecutorConfig durableExecutorConfig = this.nodeEngine.getConfig().findDurableExecutorConfig(name);
        int durability = durableExecutorConfig.getDurability();
        boolean statisticsEnabled = durableExecutorConfig.isStatisticsEnabled();
        this.executorContainerMap.put(name, new DurableExecutorContainer(this.nodeEngine, name, this.partitionId, durability, statisticsEnabled, ringBuffer));
    }

    public Operation prepareReplicationOperation(int replicaIndex) {
        HashMap<String, DurableExecutorContainer> map = new HashMap<String, DurableExecutorContainer>();
        for (DurableExecutorContainer executorContainer : this.executorContainerMap.values()) {
            if (replicaIndex > executorContainer.getDurability()) continue;
            map.put(executorContainer.getName(), executorContainer);
        }
        return map.isEmpty() ? null : new ReplicationOperation(map);
    }

    public void clearRingBuffersHavingLesserBackupCountThan(int thresholdReplicaIndex) {
        if (thresholdReplicaIndex < 0) {
            this.executorContainerMap.clear();
        }
        Iterator iterator2 = this.executorContainerMap.values().iterator();
        while (iterator2.hasNext()) {
            DurableExecutorContainer executorContainer = (DurableExecutorContainer)iterator2.next();
            if (thresholdReplicaIndex <= executorContainer.getDurability()) continue;
            iterator2.remove();
        }
    }

    public void executeAll() {
        for (DurableExecutorContainer container : this.executorContainerMap.values()) {
            container.executeAll();
        }
    }

    public void removeContainer(String name) {
        this.executorContainerMap.remove(name);
    }

    Collection<DurableExecutorContainer> getAllExecutorContainers() {
        return this.executorContainerMap.values();
    }

    boolean hasNoExecutorContainer() {
        return this.executorContainerMap.isEmpty();
    }

    DurableExecutorContainer getExistingExecutorContainer(String name) {
        return (DurableExecutorContainer)this.executorContainerMap.get(name);
    }

    private DurableExecutorContainer createExecutorContainer(String name) {
        DurableExecutorConfig durableExecutorConfig = this.nodeEngine.getConfig().findDurableExecutorConfig(name);
        int durability = durableExecutorConfig.getDurability();
        int ringBufferCapacity = durableExecutorConfig.getCapacity();
        boolean statisticsEnabled = durableExecutorConfig.isStatisticsEnabled();
        TaskRingBuffer ringBuffer = new TaskRingBuffer(ringBufferCapacity);
        return new DurableExecutorContainer(this.nodeEngine, name, this.partitionId, durability, statisticsEnabled, ringBuffer);
    }
}

