/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.SilentException;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.logging.Level;

public abstract class RaftOp
implements DataSerializable {
    private transient NodeEngine nodeEngine;

    public abstract Object run(CPGroupId var1, long var2) throws Exception;

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public RaftOp setNodeEngine(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        return this;
    }

    public <T> T getService() {
        return this.nodeEngine.getService(this.getServiceName());
    }

    protected ILogger getLogger() {
        return this.getNodeEngine().getLogger(this.getClass());
    }

    protected abstract String getServiceName();

    public void logFailure(Throwable e) {
        ILogger logger2 = this.getLogger();
        if (e instanceof SilentException) {
            if (logger2.isFinestEnabled()) {
                logger2.finest(e.getMessage(), e);
            }
        } else if (e instanceof RetryableException) {
            if (logger2.isFineEnabled()) {
                logger2.fine(e.getClass().getName() + ": " + e.getMessage());
            }
        } else if (e instanceof OutOfMemoryError) {
            try {
                logger2.severe(e.getMessage(), e);
            }
            catch (Throwable t2) {
                EmptyStatement.ignore(t2);
            }
        } else {
            Level level;
            Level level2 = level = this.nodeEngine != null && this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
            if (logger2.isLoggable(level)) {
                logger2.log(level, e.getMessage(), e);
            }
        }
    }

    protected void toString(StringBuilder sb) {
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName()).append('{');
        sb.append("serviceName='").append(this.getServiceName()).append('\'');
        this.toString(sb);
        sb.append('}');
        return sb.toString();
    }
}

