/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;

public class TranslateToPublicAddressProvider
implements InitialMembershipListener,
BooleanSupplier {
    private static final int REACHABLE_ADDRESS_TIMEOUT_MILLIS = 1000;
    private static final int NON_REACHABLE_ADDRESS_TIMEOUT_MILLIS = 3000;
    private static final int REACHABLE_CHECK_NUMBER = 3;
    private static final EndpointQualifier CLIENT_PUBLIC_ENDPOINT_QUALIFIER = EndpointQualifier.resolve(ProtocolType.CLIENT, "public");
    private final ClientNetworkConfig config;
    private final HazelcastProperties properties;
    private final ILogger logger;
    private volatile boolean translateToPublicAddress;

    public TranslateToPublicAddressProvider(ClientNetworkConfig config, HazelcastProperties properties, ILogger logger2) {
        this.config = config;
        this.properties = properties;
        this.logger = logger2;
    }

    private boolean resolve(Collection<Member> members) {
        String publicIpEnabledProperty = this.properties.getString(ClientProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED);
        if (publicIpEnabledProperty == null) {
            SSLConfig sslConfig = this.config.getSSLConfig();
            if (sslConfig != null && sslConfig.isEnabled()) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("SSL is configured. The client will use internal addresses to communicate with the cluster. If members are not reachable via private addresses, please set \"hazelcast.discovery.public.ip.enabled\" to true ");
                }
                return false;
            }
            if (this.memberInternalAddressAsDefinedInClientConfig(members)) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("There are internal addresses of members used in the config. The client will use internal addresses");
                }
                return false;
            }
            return this.membersReachableOnlyViaPublicAddress(members);
        }
        return this.properties.getBoolean(ClientProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED);
    }

    boolean memberInternalAddressAsDefinedInClientConfig(Collection<Member> members) {
        List<String> addresses = this.config.getAddresses();
        List resolvedHosts = addresses.stream().map(s2 -> {
            try {
                return InetAddress.getByName(AddressUtil.getAddressHolder(s2, -1).getAddress()).getHostAddress();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return members.stream().map(memberInfo -> {
            try {
                return memberInfo.getAddress().getInetAddress().getHostAddress();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }).anyMatch(resolvedHosts::contains);
    }

    private boolean membersReachableOnlyViaPublicAddress(Collection<Member> members) {
        ArrayList<Member> shuffledList = new ArrayList<Member>(members);
        Collections.shuffle(shuffledList);
        Iterator iter = shuffledList.iterator();
        for (int i = 0; i < 3; ++i) {
            if (!iter.hasNext()) {
                iter = shuffledList.iterator();
            }
            Member member = (Member)iter.next();
            Address publicAddress = member.getAddressMap().get(CLIENT_PUBLIC_ENDPOINT_QUALIFIER);
            Address internalAddress = member.getAddress();
            if (publicAddress == null) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("The public address is not available on the member. The client will use internal addresses");
                }
                return false;
            }
            if (this.isReachable(internalAddress, 1000)) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("The internal address is reachable. The client will use the internal addresses");
                }
                return false;
            }
            if (this.isReachable(publicAddress, 3000)) continue;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Public address + " + publicAddress + "  is not reachable. The client will use internal addresses");
            }
            return false;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Members are accessible via only public addresses. The client will use public addresses");
        }
        return true;
    }

    private boolean isReachable(Address address, int timeoutMs) {
        try (Socket s2 = new Socket();){
            s2.connect(new InetSocketAddress(address.getHost(), address.getPort()), timeoutMs);
        }
        catch (Exception e) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("TranslateToPublicAddressProvider can not reach to address " + address + " in " + timeoutMs + " millis", e);
            }
            return false;
        }
        return true;
    }

    @Override
    public void init(InitialMembershipEvent event) {
        this.translateToPublicAddress = this.resolve(event.getMembers());
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
    }

    @Override
    public boolean getAsBoolean() {
        return this.translateToPublicAddress;
    }
}

