/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddTopicConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1771264;
    public static final int RESPONSE_MESSAGE_TYPE = 1771265;
    private static final int REQUEST_GLOBAL_ORDERING_ENABLED_FIELD_OFFSET = 16;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 17;
    private static final int REQUEST_MULTI_THREADING_ENABLED_FIELD_OFFSET = 18;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 19;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddTopicConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean globalOrderingEnabled, boolean statisticsEnabled, boolean multiThreadingEnabled, @Nullable Collection<ListenerConfigHolder> listenerConfigs) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddTopicConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[19], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1771264);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, globalOrderingEnabled);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, statisticsEnabled);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 18, multiThreadingEnabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.globalOrderingEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        request.multiThreadingEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 18);
        request.name = StringCodec.decode(iterator2);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator2, ListenerConfigHolderCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1771265);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean globalOrderingEnabled;
        public boolean statisticsEnabled;
        public boolean multiThreadingEnabled;
        @Nullable
        public List<ListenerConfigHolder> listenerConfigs;
    }
}

