/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import java.util.Random;

public class WaitStrategy {
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final double multiplier;
    private final double jitter;
    private final Random random = new Random();
    private final ILogger logger;
    private int attempt;
    private int currentBackoffMillis;
    private final long clusterConnectTimeoutMillis;
    private final String clusterConnectTimeoutText;
    private long clusterConnectAttemptBegin;

    WaitStrategy(int initialBackoffMillis, int maxBackoffMillis, double multiplier, long clusterConnectTimeoutMillis, double jitter, ILogger logger2) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.multiplier = multiplier;
        this.clusterConnectTimeoutMillis = clusterConnectTimeoutMillis;
        this.clusterConnectTimeoutText = clusterConnectTimeoutMillis == Long.MAX_VALUE ? "INFINITE" : clusterConnectTimeoutMillis + " ms";
        this.jitter = jitter;
        this.logger = logger2;
    }

    public void reset() {
        this.attempt = 0;
        this.clusterConnectAttemptBegin = Clock.currentTimeMillis();
        this.currentBackoffMillis = Math.min(this.maxBackoffMillis, this.initialBackoffMillis);
    }

    public boolean sleep() {
        ++this.attempt;
        long currentTimeMillis = Clock.currentTimeMillis();
        long timePassed = currentTimeMillis - this.clusterConnectAttemptBegin;
        if (timePassed > this.clusterConnectTimeoutMillis) {
            this.logger.warning(String.format("Unable to get live cluster connection, cluster connect timeout (%s) is reached. Attempt %d.", this.clusterConnectTimeoutText, this.attempt));
            return false;
        }
        long actualSleepTime = (long)((double)this.currentBackoffMillis + (double)this.currentBackoffMillis * this.jitter * (2.0 * this.random.nextDouble() - 1.0));
        actualSleepTime = Math.min(actualSleepTime, this.clusterConnectTimeoutMillis - timePassed);
        this.logger.warning(String.format("Unable to get live cluster connection, retry in %d ms, attempt: %d, cluster connect timeout: %s, max backoff: %d ms", actualSleepTime, this.attempt, this.clusterConnectTimeoutText, this.maxBackoffMillis));
        try {
            Thread.sleep(actualSleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        this.currentBackoffMillis = (int)Math.min((double)this.currentBackoffMillis * this.multiplier, (double)this.maxBackoffMillis);
        return true;
    }
}

