/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DescribeTransactionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<TransactionState> transactionStates;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("transaction_states", new CompactArrayOf(TransactionState.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeTransactionsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeTransactionsResponseData() {
        this.throttleTimeMs = 0;
        this.transactionStates = new ArrayList<TransactionState>(0);
    }

    @Override
    public short apiKey() {
        return 65;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field transactionStates was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TransactionState> newCollection = new ArrayList<TransactionState>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TransactionState(_readable, _version));
        }
        this.transactionStates = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.transactionStates.size() + 1);
        for (TransactionState transactionStatesElement : this.transactionStates) {
            transactionStatesElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.transactionStates.size() + 1));
        for (TransactionState transactionStatesElement : this.transactionStates) {
            transactionStatesElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeTransactionsResponseData)) {
            return false;
        }
        DescribeTransactionsResponseData other = (DescribeTransactionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.transactionStates == null ? other.transactionStates != null : !this.transactionStates.equals(other.transactionStates)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.transactionStates == null ? 0 : this.transactionStates.hashCode());
        return hashCode;
    }

    @Override
    public DescribeTransactionsResponseData duplicate() {
        DescribeTransactionsResponseData _duplicate = new DescribeTransactionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<TransactionState> newTransactionStates = new ArrayList<TransactionState>(this.transactionStates.size());
        for (TransactionState _element : this.transactionStates) {
            newTransactionStates.add(_element.duplicate());
        }
        _duplicate.transactionStates = newTransactionStates;
        return _duplicate;
    }

    public String toString() {
        return "DescribeTransactionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", transactionStates=" + MessageUtil.deepToString(this.transactionStates.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<TransactionState> transactionStates() {
        return this.transactionStates;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeTransactionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeTransactionsResponseData setTransactionStates(List<TransactionState> v) {
        this.transactionStates = v;
        return this;
    }

    public static class TopicDataCollection
    extends ImplicitLinkedHashMultiCollection<TopicData> {
        public TopicDataCollection() {
        }

        public TopicDataCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TopicDataCollection(Iterator<TopicData> iterator2) {
            super(iterator2);
        }

        @Override
        public TopicData find(String topic) {
            TopicData _key = new TopicData();
            _key.setTopic(topic);
            return this.find(_key);
        }

        @Override
        public List<TopicData> findAll(String topic) {
            TopicData _key = new TopicData();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public TopicDataCollection duplicate() {
            TopicDataCollection _duplicate = new TopicDataCollection(this.size());
            for (TopicData _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class TopicData
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, ""), new Field("partitions", new CompactArrayOf(Type.INT32), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public TopicData() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicData setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class TransactionState
    implements Message {
        short errorCode;
        String transactionalId;
        String transactionState;
        int transactionTimeoutMs;
        long transactionStartTimeMs;
        long producerId;
        short producerEpoch;
        TopicDataCollection topics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, ""), new Field("transactional_id", Type.COMPACT_STRING, ""), new Field("transaction_state", Type.COMPACT_STRING, ""), new Field("transaction_timeout_ms", Type.INT32, ""), new Field("transaction_start_time_ms", Type.INT64, ""), new Field("producer_id", Type.INT64, ""), new Field("producer_epoch", Type.INT16, ""), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), "The set of partitions included in the current transaction (if active). When a transaction is preparing to commit or abort, this will include only partitions which do not have markers."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TransactionState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TransactionState() {
            this.errorCode = 0;
            this.transactionalId = "";
            this.transactionState = "";
            this.transactionTimeoutMs = 0;
            this.transactionStartTimeMs = 0L;
            this.producerId = 0L;
            this.producerEpoch = 0;
            this.topics = new TopicDataCollection(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TransactionState");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionalId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionalId had invalid length " + length);
            }
            this.transactionalId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionState had invalid length " + length);
            }
            this.transactionState = _readable.readString(length);
            this.transactionTimeoutMs = _readable.readInt();
            this.transactionStartTimeMs = _readable.readLong();
            this.producerId = _readable.readLong();
            this.producerEpoch = _readable.readShort();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            TopicDataCollection newCollection = new TopicDataCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicData(_readable, _version));
            }
            this.topics = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            Object _stringBytes = _cache.getSerializedValue(this.transactionalId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.transactionState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.transactionTimeoutMs);
            _writable.writeLong(this.transactionStartTimeMs);
            _writable.writeLong(this.producerId);
            _writable.writeShort(this.producerEpoch);
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                TopicData topicsElement = (TopicData)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TransactionState");
            }
            _size.addBytes(2);
            byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionalId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.transactionState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.transactionState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (TopicData topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TransactionState)) {
                return false;
            }
            TransactionState other = (TransactionState)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
                return false;
            }
            if (this.transactionState == null ? other.transactionState != null : !this.transactionState.equals(other.transactionState)) {
                return false;
            }
            if (this.transactionTimeoutMs != other.transactionTimeoutMs) {
                return false;
            }
            if (this.transactionStartTimeMs != other.transactionStartTimeMs) {
                return false;
            }
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.producerEpoch != other.producerEpoch) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
            hashCode = 31 * hashCode + (this.transactionState == null ? 0 : this.transactionState.hashCode());
            hashCode = 31 * hashCode + this.transactionTimeoutMs;
            hashCode = 31 * hashCode + ((int)(this.transactionStartTimeMs >> 32) ^ (int)this.transactionStartTimeMs);
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + this.producerEpoch;
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        @Override
        public TransactionState duplicate() {
            TransactionState _duplicate = new TransactionState();
            _duplicate.errorCode = this.errorCode;
            _duplicate.transactionalId = this.transactionalId;
            _duplicate.transactionState = this.transactionState;
            _duplicate.transactionTimeoutMs = this.transactionTimeoutMs;
            _duplicate.transactionStartTimeMs = this.transactionStartTimeMs;
            _duplicate.producerId = this.producerId;
            _duplicate.producerEpoch = this.producerEpoch;
            TopicDataCollection newTopics = new TopicDataCollection(this.topics.size());
            for (TopicData _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            return _duplicate;
        }

        public String toString() {
            return "TransactionState(errorCode=" + this.errorCode + ", transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", transactionState=" + (this.transactionState == null ? "null" : "'" + this.transactionState.toString() + "'") + ", transactionTimeoutMs=" + this.transactionTimeoutMs + ", transactionStartTimeMs=" + this.transactionStartTimeMs + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String transactionalId() {
            return this.transactionalId;
        }

        public String transactionState() {
            return this.transactionState;
        }

        public int transactionTimeoutMs() {
            return this.transactionTimeoutMs;
        }

        public long transactionStartTimeMs() {
            return this.transactionStartTimeMs;
        }

        public long producerId() {
            return this.producerId;
        }

        public short producerEpoch() {
            return this.producerEpoch;
        }

        public TopicDataCollection topics() {
            return this.topics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TransactionState setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TransactionState setTransactionalId(String v) {
            this.transactionalId = v;
            return this;
        }

        public TransactionState setTransactionState(String v) {
            this.transactionState = v;
            return this;
        }

        public TransactionState setTransactionTimeoutMs(int v) {
            this.transactionTimeoutMs = v;
            return this;
        }

        public TransactionState setTransactionStartTimeMs(long v) {
            this.transactionStartTimeMs = v;
            return this;
        }

        public TransactionState setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public TransactionState setProducerEpoch(short v) {
            this.producerEpoch = v;
            return this;
        }

        public TransactionState setTopics(TopicDataCollection v) {
            this.topics = v;
            return this;
        }
    }
}

