/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.logstash.logback.util.StringUtils;

public class PatternLayoutAdapter<E> {
    private static final Pattern ERROR_PATTERN = Pattern.compile("%PARSER_ERROR\\[(.*)\\]");
    private final PatternLayoutBase<E> layout;
    private Converter<E> head;
    private boolean headCaptured;

    public PatternLayoutAdapter(PatternLayoutBase<E> layout) {
        this.layout = Objects.requireNonNull(layout);
    }

    public void setContext(Context context) {
        this.layout.setContext(context);
    }

    public void setPattern(String pattern) {
        this.layout.setPattern(pattern);
    }

    public void start() throws IllegalArgumentException {
        if (this.layout.isStarted()) {
            throw new IllegalStateException("Layout is already started");
        }
        this.layout.setPostCompileProcessor(new HeadConverterCapture());
        this.layout.start();
        if (!this.headCaptured && StringUtils.isEmpty(this.layout.getPattern())) {
            throw new IllegalArgumentException("Failed to parse PatternLayout. See previous error statuses for more information.");
        }
        StringBuilder sb = new StringBuilder();
        for (Converter<E> c = this.head; c != null; c = c.getNext()) {
            if (!this.isConstantConverter(c)) continue;
            c.write(sb, null);
            Matcher matcher = ERROR_PATTERN.matcher(sb.toString());
            if (matcher.matches()) {
                String conversionWord = matcher.group(1);
                throw new IllegalArgumentException("Failed to interpret '%" + conversionWord + "' conversion word. See previous error statuses for more information.");
            }
            sb.setLength(0);
        }
    }

    public void writeTo(StringBuilder strBuilder, E event) {
        for (Converter<E> c = this.head; c != null; c = c.getNext()) {
            c.write(strBuilder, event);
        }
    }

    public boolean isConstant() {
        if (this.head == null) {
            return true;
        }
        for (Converter<E> c = this.head; c != null; c = c.getNext()) {
            if (this.isConstantConverter(c)) continue;
            return false;
        }
        return true;
    }

    public String getConstantValue() {
        if (!this.isConstant()) {
            throw new IllegalStateException("Pattern is not a constant value");
        }
        StringBuilder builder = new StringBuilder();
        this.writeTo(builder, null);
        return builder.toString();
    }

    private boolean isConstantConverter(Converter<E> converter) {
        return converter instanceof LiteralConverter;
    }

    private class HeadConverterCapture
    implements PostCompileProcessor<E> {
        private HeadConverterCapture() {
        }

        @Override
        public void process(Context context, Converter<E> head) {
            PatternLayoutAdapter.this.head = head;
            PatternLayoutAdapter.this.headCaptured = true;
        }
    }
}

