/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema register request")
public class RegisterSchemaRequest {
    private Integer version;
    private Integer id;
    private String schemaType;
    private List<SchemaReference> references = null;
    private String schema;

    public RegisterSchemaRequest() {
    }

    public RegisterSchemaRequest(ParsedSchema schema) {
        this.schemaType = schema.schemaType();
        this.references = schema.references();
        this.schema = schema.canonicalString();
    }

    public RegisterSchemaRequest(Schema schema) {
        this.version = schema.getVersion();
        this.id = schema.getId();
        this.schemaType = schema.getSchemaType();
        this.references = schema.getReferences();
        this.schema = schema.getSchema();
    }

    public static RegisterSchemaRequest fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, RegisterSchemaRequest.class);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Version number")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Globally unique identifier of the schema")
    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema definition string")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterSchemaRequest that = (RegisterSchemaRequest)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.id, that.id) && Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.references, that.references) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.references, this.version, this.id, this.schema);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        if (this.version != null) {
            buf.append("version=").append(this.version).append(", ");
        }
        if (this.id != null) {
            buf.append("id=").append(this.id).append(", ");
        }
        buf.append("schemaType=").append(this.schemaType).append(",");
        buf.append("references=").append(this.references).append(",");
        buf.append("schema=").append(this.schema).append("}");
        return buf.toString();
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }
}

