/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema definition")
public class SchemaString {
    private String schemaType = "AVRO";
    private String schemaString;
    private List<SchemaReference> references = Collections.emptyList();
    private Integer maxId;

    public SchemaString() {
    }

    public SchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    public SchemaString(Schema schema) {
        this.schemaType = schema.getSchemaType();
        this.schemaString = schema.getSchema();
        this.references = schema.getReferences();
    }

    public static SchemaString fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, SchemaString.class);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type", example="AVRO")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema string identified by the ID", example="{\"schema\": \"{\"type\": \"string\"}\"}")
    @JsonProperty(value="schema")
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty(value="schema")
    public void setSchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Maximum ID", example="1")
    @JsonProperty(value="maxId")
    public Integer getMaxId() {
        return this.maxId;
    }

    @JsonProperty(value="maxId")
    public void setMaxId(Integer maxId) {
        this.maxId = maxId;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaString that = (SchemaString)o;
        return Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.schemaString, that.schemaString) && Objects.equals(this.references, that.references) && Objects.equals(this.maxId, that.maxId);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.schemaString, this.references, this.maxId);
    }
}

