/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.sanitizer;

import com.networknt.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SanitizerConfig {
    public static final String CONFIG_NAME = "sanitizer";
    public static final String DEFAULT_ENCODER = "javascript-source";
    private boolean enabled;
    private boolean bodyEnabled;
    private String bodyEncoder;
    private List<String> bodyAttributesToIgnore;
    private List<String> bodyAttributesToEncode;
    private boolean headerEnabled;
    private String headerEncoder;
    private List<String> headerAttributesToIgnore;
    private List<String> headerAttributesToEncode;
    private final Map<String, Object> mappedConfig;

    private SanitizerConfig(String configName) {
        this.mappedConfig = Config.getInstance().getJsonMapConfig(configName);
        this.setBodyAttributesToEncodeList();
        this.setBodyAttributesToIgnoreList();
        this.setHeaderAttributesToEncodeList();
        this.setHeaderAttributesToIgnoreList();
        this.setConfigData();
    }

    public static SanitizerConfig load() {
        return new SanitizerConfig(CONFIG_NAME);
    }

    @Deprecated
    public static SanitizerConfig load(String configName) {
        return new SanitizerConfig(configName);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isBodyEnabled() {
        return this.bodyEnabled;
    }

    public void setBodyEnabled(boolean bodyEnabled) {
        this.bodyEnabled = bodyEnabled;
    }

    public String getBodyEncoder() {
        return this.bodyEncoder;
    }

    public void setBodyEncoder(String bodyEncoder) {
        this.bodyEncoder = bodyEncoder;
    }

    public List<String> getBodyAttributesToIgnore() {
        return this.bodyAttributesToIgnore;
    }

    public void setBodyAttributesToIgnore(List<String> bodyAttributesToIgnore) {
        this.bodyAttributesToIgnore = bodyAttributesToIgnore;
    }

    public List<String> getBodyAttributesToEncode() {
        return this.bodyAttributesToEncode;
    }

    public void setBodyAttributesToEncode(List<String> bodyAttributesToEncode) {
        this.bodyAttributesToEncode = bodyAttributesToEncode;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean headerEnabled) {
        this.headerEnabled = headerEnabled;
    }

    public String getHeaderEncoder() {
        return this.headerEncoder;
    }

    public void setHeaderEncoder(String headerEncoder) {
        this.headerEncoder = headerEncoder;
    }

    public List<String> getHeaderAttributesToIgnore() {
        return this.headerAttributesToIgnore;
    }

    public void setHeaderAttributesToIgnore(List<String> headerAttributesToIgnore) {
        this.headerAttributesToIgnore = headerAttributesToIgnore;
    }

    public List<String> getHeaderAttributesToEncode() {
        return this.headerAttributesToEncode;
    }

    public void setHeaderAttributesToEncode(List<String> headerAttributesToEncode) {
        this.headerAttributesToEncode = headerAttributesToEncode;
    }

    public void setConfigData() {
        Object object = this.mappedConfig.get("enabled");
        if (object != null && ((Boolean)object).booleanValue()) {
            this.enabled = true;
        }
        if ((object = this.mappedConfig.get("bodyEnabled")) != null && ((Boolean)object).booleanValue()) {
            this.bodyEnabled = true;
        } else {
            object = this.mappedConfig.get("sanitizeBody");
            if (object != null && ((Boolean)object).booleanValue()) {
                this.bodyEnabled = true;
            }
        }
        object = this.mappedConfig.get("headerEnabled");
        if (object != null && ((Boolean)object).booleanValue()) {
            this.headerEnabled = true;
        } else {
            object = this.mappedConfig.get("sanitizeHeader");
            if (object != null && ((Boolean)object).booleanValue()) {
                this.headerEnabled = true;
            }
        }
        object = this.mappedConfig.get("bodyEncoder");
        this.bodyEncoder = object != null ? (String)object : DEFAULT_ENCODER;
        object = this.mappedConfig.get("headerEncoder");
        this.headerEncoder = object != null ? (String)object : DEFAULT_ENCODER;
    }

    public void setBodyAttributesToEncodeList() {
        this.bodyAttributesToEncode = new ArrayList<String>();
        if (this.mappedConfig.get("bodyAttributesToEncode") != null && this.mappedConfig.get("bodyAttributesToEncode") instanceof String) {
            this.bodyAttributesToEncode.add((String)this.mappedConfig.get("bodyAttributesToEncode"));
        } else {
            this.bodyAttributesToEncode = (List)this.mappedConfig.get("bodyAttributesToEncode");
        }
    }

    public void setBodyAttributesToIgnoreList() {
        this.bodyAttributesToIgnore = new ArrayList<String>();
        if (this.mappedConfig.get("bodyAttributesToIgnore") != null && this.mappedConfig.get("bodyAttributesToIgnore") instanceof String) {
            this.bodyAttributesToIgnore.add((String)this.mappedConfig.get("bodyAttributesToIgnore"));
        } else {
            this.bodyAttributesToIgnore = (List)this.mappedConfig.get("bodyAttributesToIgnore");
        }
    }

    public void setHeaderAttributesToEncodeList() {
        this.headerAttributesToEncode = new ArrayList<String>();
        if (this.mappedConfig.get("headerAttributesToEncode") != null && this.mappedConfig.get("headerAttributesToEncode") instanceof String) {
            this.headerAttributesToEncode.add((String)this.mappedConfig.get("headerAttributesToEncode"));
        } else {
            this.headerAttributesToEncode = (List)this.mappedConfig.get("headerAttributesToEncode");
        }
    }

    public void setHeaderAttributesToIgnoreList() {
        this.headerAttributesToIgnore = new ArrayList<String>();
        if (this.mappedConfig.get("headerAttributesToIgnore") != null && this.mappedConfig.get("headerAttributesToIgnore") instanceof String) {
            this.headerAttributesToIgnore.add((String)this.mappedConfig.get("headerAttributesToIgnore"));
        } else {
            this.headerAttributesToIgnore = (List)this.mappedConfig.get("headerAttributesToIgnore");
        }
    }
}

