/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.DefaultInjectableSpecValidator;
import com.networknt.openapi.InjectableSpecValidator;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHandlerConfig;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.parameter.ParameterDeserializer;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(OpenApiHandler.class);
    public static final String CONFIG_NAME = "openapi";
    public static final String SPEC_INJECT = "openapi-inject";
    public static final String HANDLER_CONFIG = "handler";
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_QUERY_PARAMETERS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_PATH_PARAMETERS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_HEADER_PARAMETERS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_COOKIE_PARAMETERS = AttachmentKey.create(Map.class);
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    HandlerConfig handlerConfig;
    static OpenApiHandlerConfig config;
    public static Map<String, OpenApiHelper> helperMap;
    public static OpenApiHelper helper;
    private volatile HttpHandler next;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OpenApiHandler(OpenApiHandlerConfig cfg) {
        config = cfg;
        Map<String, Object> inject = Config.getInstance().getJsonMapConfig(SPEC_INJECT);
        if (config.isMultipleSpec()) {
            Map<String, Object> pathSpecMapping = config.getPathSpecMapping();
            helperMap = new HashMap<String, OpenApiHelper>();
            for (Map.Entry<String, Object> entry : pathSpecMapping.entrySet()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("key = {} value = {}", (Object)entry.getKey(), entry.getValue());
                }
                Map<String, Object> openapi = Config.getInstance().getJsonMapConfigNoCache((String)entry.getValue());
                this.validateSpec(openapi, inject, entry.getKey());
                OpenApiHelper.merge(openapi, inject);
                try {
                    OpenApiHelper h2 = new OpenApiHelper(Config.getInstance().getMapper().writeValueAsString(openapi));
                    helperMap.put(entry.getKey(), h2);
                }
                catch (JsonProcessingException e) {
                    logger.error("merge specification failed for " + entry.getValue());
                    throw new RuntimeException("merge specification failed for " + entry.getValue());
                }
            }
            return;
        } else {
            Map<String, Object> openapi = Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME);
            this.handlerConfig = (HandlerConfig)Config.getInstance().getJsonObjectConfig(HANDLER_CONFIG, HandlerConfig.class);
            this.validateSpec(openapi, inject, "openapi.yml");
            OpenApiHelper.merge(openapi, inject);
            try {
                helper = new OpenApiHelper(Config.getInstance().getMapper().writeValueAsString(openapi));
                if (!OpenApiHandler.helper.basePath.isEmpty() || this.handlerConfig == null || this.handlerConfig.getBasePath() == null) return;
                helper.setBasePath(this.handlerConfig.getBasePath());
                return;
            }
            catch (JsonProcessingException e) {
                logger.error("merge specification failed");
                throw new RuntimeException("merge specification failed");
            }
        }
    }

    public OpenApiHandler() {
        this(OpenApiHandlerConfig.load());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("OpenApiHandler.handleRequest starts.");
        }
        if (config.isMultipleSpec()) {
            String p = exchange.getRequestPath();
            boolean found = false;
            for (Map.Entry<String, OpenApiHelper> entry : helperMap.entrySet()) {
                String httpMethod;
                ApiNormalisedPath requestPath;
                if (!p.startsWith(entry.getKey())) continue;
                found = true;
                OpenApiHelper h2 = entry.getValue();
                Optional<NormalisedPath> maybeApiPath = h2.findMatchingApiPath(requestPath = new ApiNormalisedPath(exchange.getRequestURI(), h2.basePath));
                if (maybeApiPath.isEmpty()) {
                    this.setExchangeFailed(exchange, STATUS_INVALID_REQUEST_PATH, requestPath.normalised());
                    return;
                }
                NormalisedPath openApiPathString = maybeApiPath.get();
                Path path = h2.openApi3.getPath(openApiPathString.original());
                Operation operation = path.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
                if (operation == null) {
                    this.setExchangeFailed(exchange, STATUS_METHOD_NOT_ALLOWED, httpMethod, openApiPathString.normalised());
                    return;
                }
                OpenApiOperation openApiOperation = new OpenApiOperation(openApiPathString, path, httpMethod, operation);
                try {
                    ParameterDeserializer.deserialize(exchange, openApiOperation);
                }
                catch (Throwable t2) {
                    logger.error(t2.getMessage(), t2);
                }
                String endpoint = openApiPathString.normalised() + "@" + httpMethod.toString().toLowerCase();
                Map<String, OpenApiOperation> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO) == null ? new HashMap() : exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
                auditInfo.put("endpoint", (OpenApiOperation)((Object)endpoint));
                auditInfo.put("openapi_operation", openApiOperation);
                exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
                break;
            }
            if (!found && !config.isIgnoreInvalidPath()) {
                this.setExchangeFailed(exchange, STATUS_INVALID_REQUEST_PATH, p);
                return;
            }
        } else {
            String httpMethod;
            ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI(), OpenApiHandler.helper.basePath);
            Optional<NormalisedPath> maybeApiPath = helper.findMatchingApiPath(requestPath);
            if (maybeApiPath.isEmpty()) {
                if (config.isIgnoreInvalidPath()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("OpenApiHandler.handleRequest ends with ignoreInvalidPath.");
                    }
                    Handler.next(exchange, this.next);
                } else {
                    this.setExchangeFailed(exchange, STATUS_INVALID_REQUEST_PATH, requestPath.normalised());
                }
                return;
            }
            NormalisedPath openApiPathString = maybeApiPath.get();
            Path path = OpenApiHandler.helper.openApi3.getPath(openApiPathString.original());
            Operation operation = path.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
            if (operation == null) {
                this.setExchangeFailed(exchange, STATUS_METHOD_NOT_ALLOWED, httpMethod, openApiPathString.normalised());
                return;
            }
            OpenApiOperation openApiOperation = new OpenApiOperation(openApiPathString, path, httpMethod, operation);
            try {
                ParameterDeserializer.deserialize(exchange, openApiOperation);
            }
            catch (Throwable t3) {
                logger.error(t3.getMessage(), t3);
            }
            String endpoint = openApiPathString.normalised() + "@" + httpMethod.toString().toLowerCase();
            Map<String, OpenApiOperation> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO) == null ? new HashMap() : exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
            auditInfo.put("endpoint", (OpenApiOperation)((Object)endpoint));
            auditInfo.put("openapi_operation", openApiOperation);
            exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("OpenApiHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    private void validateSpec(Map<String, Object> openapiMap, Map<String, Object> openapiInjectMap, String specName) {
        InjectableSpecValidator validator = SingletonServiceFactory.getBean(InjectableSpecValidator.class);
        if (validator == null) {
            validator = new DefaultInjectableSpecValidator();
        }
        if (!validator.isValid(openapiMap, openapiInjectMap)) {
            logger.error("the original spec {} and injected spec has error, please check the validator {}", (Object)specName, (Object)validator.getClass().getName());
            throw new RuntimeException("inject spec error for " + specName);
        }
    }

    private void setExchangeFailed(HttpServerExchange exchange, String err, Object ... args2) {
        this.setExchangeStatus(exchange, err, args2);
        if (logger.isDebugEnabled()) {
            logger.debug("OpenApiHandler.handleRequest ends with an error.");
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        boolean enabled = false;
        enabled = OpenApiHandler.config.multipleSpec ? config.getMappedConfig().size() > 0 : OpenApiHandler.helper.openApi3 != null;
        return enabled;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(OpenApiHandler.class.getName(), Config.getInstance().getJsonMapConfig(CONFIG_NAME), null);
    }

    @Override
    public void reload() {
        this.handlerConfig = (HandlerConfig)Config.getInstance().getJsonObjectConfig(HANDLER_CONFIG, HandlerConfig.class);
    }

    protected static Map<String, ?> mergeMaps(Map preferredMap, Map alternativeMap) {
        HashMap mergedMap = new HashMap();
        if (null != alternativeMap) {
            mergedMap.putAll(alternativeMap);
        }
        if (null != preferredMap) {
            mergedMap.putAll(preferredMap);
        }
        return Collections.unmodifiableMap(mergedMap);
    }

    protected static Map<String, Object> nonNullMap(Map<String, Object> map) {
        return null == map ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    public static Map<String, ?> getQueryParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getQueryParameters(exchange, false);
    }

    public static Map<String, ?> getQueryParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map<String, Object> deserializedQueryParamters = exchange.getAttachment(DESERIALIZED_QUERY_PARAMETERS);
        return deserializedValueOnly ? OpenApiHandler.nonNullMap(deserializedQueryParamters) : OpenApiHandler.mergeMaps(deserializedQueryParamters, exchange.getQueryParameters());
    }

    public static Map<String, ?> getPathParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getPathParameters(exchange, false);
    }

    public static Map<String, ?> getPathParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map<String, Object> deserializedPathParamters = exchange.getAttachment(DESERIALIZED_PATH_PARAMETERS);
        return deserializedValueOnly ? OpenApiHandler.nonNullMap(deserializedPathParamters) : OpenApiHandler.mergeMaps(deserializedPathParamters, exchange.getPathParameters());
    }

    public static Map<String, ?> getHeaderParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getHeaderParameters(exchange, false);
    }

    public static Map<String, ?> getHeaderParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map<String, Object> deserializedHeaderParameters = exchange.getAttachment(DESERIALIZED_HEADER_PARAMETERS);
        if (!deserializedValueOnly) {
            HeaderMap headers = exchange.getRequestHeaders();
            if (null == headers) {
                return Collections.emptyMap();
            }
            HashMap<String, HeaderValues> headerMap = new HashMap<String, HeaderValues>();
            for (HttpString headerName : headers.getHeaderNames()) {
                headerMap.put(headerName.toString(), headers.get(headerName));
            }
            return OpenApiHandler.mergeMaps(deserializedHeaderParameters, headerMap);
        }
        return OpenApiHandler.nonNullMap(deserializedHeaderParameters);
    }

    public static Map<String, ?> getCookieParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getCookieParameters(exchange, false);
    }

    public static Map<String, ?> getCookieParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map<String, Object> deserializedCookieParamters = exchange.getAttachment(DESERIALIZED_COOKIE_PARAMETERS);
        return deserializedValueOnly ? OpenApiHandler.nonNullMap(deserializedCookieParamters) : OpenApiHandler.mergeMaps(deserializedCookieParamters, exchange.getRequestCookies());
    }

    public static String getBasePath(String requestPath) {
        String basePath;
        block2: {
            block1: {
                basePath = "";
                if (helper == null) break block1;
                basePath = OpenApiHandler.helper.basePath;
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("Found basePath for single spec from OpenApiHandler helper: {}", (Object)basePath);
                break block2;
            }
            for (Map.Entry<String, OpenApiHelper> entry : helperMap.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                basePath = entry.getKey();
                if (!logger.isTraceEnabled()) break;
                logger.trace("Found basePath for multiple specs from OpenApiHandler helper HashMap: {}", (Object)basePath);
                break;
            }
        }
        return basePath;
    }

    public static OpenApiHelper getHelper(String requestPath) {
        OpenApiHelper helper = null;
        if (OpenApiHandler.helper != null) {
            helper = OpenApiHandler.helper;
        } else {
            for (Map.Entry<String, OpenApiHelper> entry : helperMap.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                helper = entry.getValue();
                break;
            }
        }
        return helper;
    }
}

