/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.key.handler;

import com.networknt.body.BodyHandler;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.exception.ApiException;
import com.networknt.exception.ClientException;
import com.networknt.handler.LightHttpHandler;
import com.networknt.monad.Result;
import com.networknt.oauth.cache.AuditInfoHandler;
import com.networknt.oauth.cache.ClientUtil;
import com.networknt.oauth.cache.OAuthConfig;
import com.networknt.oauth.cache.model.AuditInfo;
import com.networknt.oauth.cache.model.OauthService;
import com.networknt.security.SecurityConfig;
import com.networknt.status.Status;
import com.networknt.utility.HashUtil;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2KeyKeyIdGetHandler
extends AuditInfoHandler
implements LightHttpHandler {
    static final Logger logger = LoggerFactory.getLogger(Oauth2KeyKeyIdGetHandler.class);
    static final String CONFIG_SECURITY = "security";
    static final String KEY_NOT_FOUND = "ERR12017";
    static final String MISSING_AUTHORIZATION_HEADER = "ERR12002";
    static final String CLIENT_NOT_FOUND = "ERR12014";
    static final String RUNTIME_EXCEPTION = "ERR10010";
    static final String UNAUTHORIZED_CLIENT = "ERR12007";
    static final String INVALID_KEY_ID = "ERR12030";
    private static final String BASIC_PREFIX = Headers.BASIC + " ";
    private static final String LOWERCASE_BASIC_PREFIX = BASIC_PREFIX.toLowerCase(Locale.ENGLISH);
    private static final int PREFIX_LENGTH = BASIC_PREFIX.length();
    private static final String COLON = ":";
    private static final OAuthConfig config = (OAuthConfig)Config.getInstance().getJsonObjectConfig("oauth", OAuthConfig.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String keyId = exchange.getQueryParameters().get("keyId").getFirst();
        if (logger.isDebugEnabled()) {
            logger.debug("keyId = " + keyId);
        }
        SecurityConfig config = SecurityConfig.load(CONFIG_SECURITY);
        Map<String, Object> certificateConfig = config.getCertificate();
        String provider_id = config.getProviderId();
        if (this.getProviderId(keyId) == null || "00".equals(this.getProviderId(keyId)) || provider_id.equals(this.getProviderId(keyId))) {
            String filename;
            if (this.getProviderId(keyId) == null || provider_id.equals(this.getProviderId(keyId))) {
                HeaderValues values2 = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
                if (values2 == null) {
                    this.setExchangeStatus(exchange, MISSING_AUTHORIZATION_HEADER, new Object[0]);
                    this.processAudit(exchange);
                    return;
                }
                String authHeader = values2.getFirst();
                if (authHeader == null) {
                    this.setExchangeStatus(exchange, MISSING_AUTHORIZATION_HEADER, new Object[0]);
                    this.processAudit(exchange);
                    return;
                }
                if (this.authenticate(authHeader) == null) {
                    this.setExchangeStatus(exchange, UNAUTHORIZED_CLIENT, new Object[0]);
                    this.processAudit(exchange);
                    return;
                }
            }
            if ((filename = (String)certificateConfig.get(this.getKeyId(keyId))) != null) {
                String content = Config.getInstance().getStringFromFile(filename);
                if (logger.isDebugEnabled()) {
                    logger.debug("certificate = " + content);
                }
                if (content != null) {
                    exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "application/text");
                    exchange.getResponseSender().send(content);
                } else {
                    this.setExchangeStatus(exchange, KEY_NOT_FOUND, keyId);
                }
            } else {
                this.setExchangeStatus(exchange, INVALID_KEY_ID, keyId);
            }
        } else {
            String content = this.getCertificateFromProvider(this.getProviderId(keyId), this.getKeyId(keyId));
            if (logger.isDebugEnabled()) {
                logger.debug("certificate from provider = " + content);
            }
            if (content != null) {
                exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "application/text");
                exchange.getResponseSender().send(content);
            } else {
                this.setExchangeStatus(exchange, KEY_NOT_FOUND, keyId);
            }
        }
        this.processAudit(exchange);
    }

    private String authenticate(String authHeader) throws ApiException {
        String result = null;
        if (authHeader.toLowerCase(Locale.ENGLISH).startsWith(LOWERCASE_BASIC_PREFIX)) {
            String base64Challenge = authHeader.substring(PREFIX_LENGTH);
            try {
                ByteBuffer decode = FlexBase64.decode(base64Challenge);
                Charset charset = StandardCharsets.UTF_8;
                String plainChallenge = new String(decode.array(), decode.arrayOffset(), decode.limit(), charset);
                logger.debug("Found basic auth header %s (decoded using charset %s) in %s", plainChallenge, charset, authHeader);
                int colonPos = plainChallenge.indexOf(COLON);
                if (colonPos > -1) {
                    String clientId = plainChallenge.substring(0, colonPos);
                    String clientSecret = plainChallenge.substring(colonPos + 1);
                    Result<String> resultClient = ClientUtil.getClientById(clientId);
                    if (resultClient.isFailure()) {
                        throw new ApiException(resultClient.getError());
                    }
                    Map<String, Object> clientMap = JsonMapper.string2Map(resultClient.getResult());
                    if (!HashUtil.validatePassword(clientSecret.toCharArray(), (String)clientMap.get("clientSecret"))) {
                        throw new ApiException(new Status(UNAUTHORIZED_CLIENT, new Object[0]));
                    }
                    result = clientId;
                }
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                logger.error("Exception:", e);
                throw new ApiException(new Status(RUNTIME_EXCEPTION, new Object[0]));
            }
        }
        return result;
    }

    private String getCertificateFromProvider(String providerId, String keyId) throws ClientException, ApiException {
        Result<String> resultProvider = ClientUtil.getProviderDetail(providerId);
        String key = null;
        if (resultProvider.isSuccess()) {
            Map<String, Object> providerMap = JsonMapper.string2Map(resultProvider.getResult());
            KeyRequest keyRequest = new KeyRequest(keyId);
            keyRequest.setServerUrl((String)providerMap.get("serverUrl"));
            keyRequest.setUri(providerMap.get("uri") + "/00" + keyId);
            keyRequest.setEnableHttp2(true);
            key = OauthHelper.getKey(keyRequest);
        }
        return key;
    }

    private String getProviderId(String keyId) {
        if (keyId.length() < 4) {
            return null;
        }
        return keyId.substring(0, 2);
    }

    private String getKeyId(String keyId) {
        if (keyId.length() < 4) {
            return keyId;
        }
        return keyId.substring(2);
    }

    private void processAudit(HttpServerExchange exchange) throws Exception {
        if (config.isEnableAudit()) {
            AuditInfo auditInfo = new AuditInfo();
            auditInfo.setServiceId(OauthService.OAUTH_KEY);
            auditInfo.setEndpoint(exchange.getHostName() + exchange.getRelativePath());
            auditInfo.setRequestHeader(exchange.getRequestHeaders().toString());
            auditInfo.setRequestBody(Config.getInstance().getMapper().writeValueAsString(exchange.getAttachment(BodyHandler.REQUEST_BODY)));
            auditInfo.setResponseCode(exchange.getStatusCode());
            auditInfo.setResponseHeader(exchange.getResponseHeaders().toString());
            auditInfo.setResponseBody(Config.getInstance().getMapper().writeValueAsString(exchange.getResponseCookies()));
            this.saveAudit(auditInfo);
        }
    }
}

